INSERT INTO mgst.experiment_device (
    SELECT
      date,
      app_version,
      device_id,
      experiment_id,
      experiment_group,
      experiment_version
    FROM cubes.expo_eb_preagg
    WHERE
      date >= %(start_date)s
      AND date < %(end_date)s
      AND (
        experiment_name LIKE '%%mgst%%'
        OR experiment_name LIKE '%%clipfinity%%'
        OR experiment_name IN (
          'android_floating_chat',
          'android_logged_out',
          'ios_browse_updates',
          'ios_login_required',
          'ios_profile_upload',
          'logged_out_notifications'
        )
      )
      AND NOT experiment_name in (
        'android_mgst_localized_streams',
        'ios_mgst_broadcasting_upsell',
        'mobile_web_mgst_experiment_baseline'
      )
  );