INSERT INTO mgst.experiment_lifecycle (
    SELECT %(start_date)s :: DATE as date,
      nvl(t2.device_id, t1.device_id) as device_id,
      nvl(t2.lifecycle_stage, t1.lifecycle_stage) as lifecycle_stage
    FROM (
      SELECT
        device_id,
        lifecycle_stage
      FROM  mgst.experiment_lifecycle t1
      WHERE 
        t1.date = %(start_date)s :: DATE - INTERVAL '1 day'
    ) t1
    FULL JOIN (
      SELECT
        device_id,
        lifecycle_stage
      FROM cubes.viewers_daily_by_lifecycle_stage_2020
      WHERE
        day = %(start_date)s
        AND device_id IN (
          SELECT
            distinct device_id
          FROM mgst.experiment_device
          WHERE
            date >= %(start_date)s :: DATE - INTERVAL '60 days'
            AND date <= %(start_date)s
        )
    ) t2
    ON t1.device_id = t2.device_id
  );