INSERT INTO mgst.expo_five_minute_play (
    SELECT
      date,
      device_id,
      platform,
      country,
      referral_source,
      game_on_session_start,
      logged_in,
      five_minute_play_ct
    FROM cubes.expo_device_id_fact_five_minute_play_ct
    WHERE
      date >= %(start_date)s
      AND date < %(end_date)s
      AND device_id IN (
        SELECT
          distinct device_id
        FROM mgst.experiment_device
        WHERE
          date >= %(start_date)s :: DATE - INTERVAL '60 days'
          AND date < %(end_date)s
      )
  );