CREATE TABLE IF NOT EXISTS mgst."minute-watched" (
  date TIMESTAMP,
  app_fullscreen BOOLEAN,
  app_session_id varchar(56),
  app_version varchar(32),
  app_window_height int,
  app_window_width int,
  autoplayed BOOLEAN,
  auto_muted BOOLEAN,
  average_bitrate float,
  backend varchar(32),
  backend_version varchar(16),
  battery_percent float,
  broadcaster_software varchar(16),
  broadcaster_software_long varchar(32),
  broadcast_id bigint,
  browser varchar(180),
  browser_family varchar(32),
  browser_version varchar(32),
  buffer_empty_count bigint,
  captions_enabled BOOLEAN,
  channel varchar(25),
  channel_id varchar(255),
  channel_restriction_type varchar(255),
  charging BOOLEAN,
  chat_visibility_status varchar(16),
  chat_visible BOOLEAN,
  chromecast_sender varchar(8),
  chromecast_sender_long varchar(40),
  client_app varchar(32),
  client_build_id varchar(255),
  client_time TIMESTAMP,
  clock_drift int,
  cluster varchar(16),
  collapse_left BOOLEAN,
  collapse_right BOOLEAN,
  collection_id varchar(32),
  collection_session_id varchar(32),
  community_id varchar(36),
  community_name varchar(32),
  content varchar(64),
  content_id varchar(64),
  content_mode varchar(32),
  core_version varchar(32),
  current_bitrate float,
  current_fps float,
  customer_id varchar(64),
  decoded_frames int,
  device_diagonal float,
  device_id varchar(32),
  device_manufacturer varchar(32),
  device_model varchar(32),
  device_os_version varchar(5),
  domain varchar(32),
  dropped_frames int,
  encrypted BOOLEAN,
  estimated_bandwidth bigint,
  viewer_exemption_status varchar(255),
  flash_version varchar(16),
  game varchar(64),
  hidden BOOLEAN,
  buffer_size bigint,
  hls_latency_broadcaster bigint,
  hls_latency_encoder bigint,
  hls_target_duration varchar(8),
  host_channel varchar(25),
  host_channel_id varchar(255),
  impression_id varchar(64),
  ip varchar(15),
  country varchar(255),
  city varchar(255),
  region varchar(255),
  asn varchar(255),
  is_fallback_player BOOLEAN,
  is_https BOOLEAN,
  item_position int,
  item_tracking_id varchar(64),
  language varchar(32),
  language_short varchar(8),
  latency_mode_toggle BOOLEAN,
  live BOOLEAN,
  login varchar(25),
  low_latency BOOLEAN,
  low_latency_forced BOOLEAN,
  manifest_broadcast_id bigint,
  manifest_cluster varchar(5),
  manifest_node varchar(13),
  manifest_node_type varchar(255),
  medium varchar(32),
  minutes_logged bigint,
  mobile_connection_type varchar(32),
  multistream_id varchar(255),
  multistream_presentation_id varchar(255),
  multistream_session_id varchar(255),
  muted BOOLEAN,
  node varchar(32),
  orientation varchar(255),
  os varchar(13),
  os_name varchar(32),
  os_version varchar(32),
  partner BOOLEAN,
  percent_width float,
  platform varchar(40),
  playback_mode varchar(56),
  player varchar(32),
  player_size_mode varchar(30),
  play_session_id varchar(32),
  previous_tracking_id varchar(255),
  quality varchar(16),
  quality_change_count bigint,
  referrer varchar(128),
  referrer_domain varchar(32),
  referrer_host varchar(32),
  referrer_url varchar(110),
  rendered_frames int,
  channel_restriction_status varchar(255),
  row_name varchar(64),
  row_position int,
  search_query_id varchar(72),
  search_session_id varchar(72),
  seconds_offset float,
  serving_id varchar(32),
  squad_stream_id varchar(255),
  squad_stream_presentation_id varchar(255),
  squad_stream_session_id varchar(255),
  staff BOOLEAN,
  stream_format varchar(16),
  subscriber_web BOOLEAN,
  tab_session_id varchar(32),
  tag_filter_set_long varchar(400),
  tag_filter_set varchar(600),
  tag_set_long varchar(400),
  tag_set varchar(600),
  "time" TIMESTAMP,
  time_utc TIMESTAMP,
  transcoder_type varchar(64),
  transport_download_bytes bigint,
  transport_download_duration bigint,
  transport_first_byte_latency bigint,
  transport_segments bigint,
  transport_segment_duration bigint,
  turbo BOOLEAN,
  ui_version varchar(8),
  url varchar(128),
  user_agent varchar(255),
  user_id varchar(255),
  video_buffer_size float,
  vid_display_height int,
  vid_display_width int,
  video_height bigint,
  video_width bigint,
  viewability_client_height bigint,
  viewability_client_width bigint,
  viewability_percent_viewable int,
  viewer_exemption_reason varchar(255),
  vod_cdn_origin varchar(32),
  vod_cdn_region varchar(32),
  vod_format varchar(16),
  vod_id varchar(16),
  vod_timestamp float,
  vod_type varchar(16),
  volume float
) DISTKEY (device_id) SORTKEY ("time");