from datetime import datetime
import subprocess
import sys
import csv
import boto3
import tempfile
import time
import pandas as pd
import os

from absl import logging
from psycopg2.extras import execute_values

bucket = 'mgst-redshift-temp'

s3 = boto3.client('s3')


def run(cmd, dry_run=False):
    logging.info(" ".join(cmd))

    if dry_run:
        return

    proc = subprocess.run(cmd,
                          stdout=sys.stdout,
                          stderr=sys.stderr,
                          )

    logging.info("exit code: {}".format(proc.returncode))


def query(con, sql, params=None, fetch=False):
    cursor = con.cursor()
    try:
        cursor.execute(sql, params)
        if fetch:
            return cursor.fetchall()
        con.commit()
    except:
        con.rollback()
        raise


def upsert_data(con, table, columns, keys, data, page_size=100000):
    try:
        cursor = con.cursor()
        cursor.execute(f"CREATE TEMP TABLE staging (LIKE {table})")

        _, temp_file = tempfile.mkstemp()
        df = pd.DataFrame(data, columns=columns)

        df.to_csv(temp_file, index=False, header=False)
        s3_file = str(time.time()) + '.csv'

        s3.upload_file(temp_file, bucket, s3_file)

        cursor.execute(f"""
            COPY staging({",".join(columns)})
            FROM 's3://{bucket}/{s3_file}'
            IAM_ROLE 'arn:aws:iam::424255581144:role/esports-experience-tahoe-replica-s3-access'
            CSV;
        """)

        duplicated = " AND ".join(
            map(lambda k: f"{table}.{k} = staging.{k}", keys))

        cursor.execute(f"""
            DELETE
            FROM {table}
            USING staging
            WHERE {duplicated};

            INSERT INTO {table} ("{'", "'.join(columns)}")
            SELECT "{'", "'.join(columns)}"
            FROM staging;

            DROP TABLE staging;
            """)

        try:
            os.remove(temp_file)
        except OSError:
            pass

        con.commit()
    except:
        con.rollback()
        raise


def upsert_data_old(con, table, columns, keys, data, page_size=100000):
    try:
        cursor = con.cursor()
        cursor.execute(f"CREATE TEMP TABLE staging (LIKE {table})")

        duplicated = " AND ".join(
            map(lambda k: f"{table}.{k} = staging.{k}", keys))

        execute_values(cursor, f"""
            INSERT INTO staging ("{'", "'.join(columns)}")
            VALUES %s
            """, data, page_size=page_size)

        cursor.execute(f"""
            DELETE
            FROM {table}
            USING staging
            WHERE {duplicated};

            INSERT INTO {table} ("{'", "'.join(columns)}")
            SELECT "{'", "'.join(columns)}"
            FROM staging;

            DROP TABLE staging;
            """)

        con.commit()
    except:
        con.rollback()
        raise


def date_validator(required=True):
    def validator(x):
        if (not required) and (not x):
            return True

        try:
            datetime.strptime(x, '%Y-%m-%d')
            return True
        except:
            pass
        return False
    return validator
