import subprocess
import sys
import os
from datetime import datetime, timedelta
import pytz

from absl import app, logging, flags
from absl.flags import FLAGS

from mgst_data.tahoe_speedup import EXPERIMENT_TABLES
from mgst_data.utils import run

flags.DEFINE_string('start_date', None, 'Starting Date (2019-01-01)')
flags.DEFINE_string('end_date', None, 'Ending Date (2019-02-01)')
flags.DEFINE_string('table', None, 'table name')

def main(_argv):
    start = datetime.strptime(FLAGS.start_date, "%Y-%m-%d")
    end = datetime.strptime(FLAGS.end_date, "%Y-%m-%d")

    if FLAGS.table:
        tahoe_speed_up_tables = [FLAGS.table]
    else:
        tahoe_speed_up_tables = EXPERIMENT_TABLES

    # Load table from tahoe to our redshift
    while start < end:
        start_date = start.strftime("%Y-%m-%d")
        start += timedelta(days=1)
        end_date = start.strftime("%Y-%m-%d")

        for table in tahoe_speed_up_tables:
            logging.info("%s %s %s", table, start_date, end_date)

            run([sys.executable, 'scripts/tahoe_speedup.py',
                 '--table_name', table,
                 '--start_date', start_date, '--end_date', end_date])


if __name__ == '__main__':
    app.run(main)
