import subprocess
import sys
import os
from datetime import datetime, timedelta
import pytz

from absl import app, logging, flags
from absl.flags import FLAGS

from mgst_data.tahoe_speedup import EXPERIMENT_TABLES
from mgst_data.utils import run

flags.DEFINE_string('start_date', None, 'Starting Date (2019-01-01)')
flags.DEFINE_string('end_date', None, 'Ending Date (2019-02-01)')
flags.DEFINE_string('script', None, 'script name')


def main(_argv):
    start = datetime.strptime(FLAGS.start_date, "%Y-%m-%d")
    end = datetime.strptime(FLAGS.end_date, "%Y-%m-%d")

    # Load table from tahoe to our redshift
    while start < end:
        start_date = start.strftime("%Y-%m-%d")
        start += timedelta(days=1)
        end_date = start.strftime("%Y-%m-%d")

        run([sys.executable, FLAGS.script, '--start_date',
             start_date, '--end_date', end_date])


if __name__ == '__main__':
    app.run(main)
