import psycopg2
from mgst_data.config import DB_HOST, DB_USER, DB_PASSWORD
from mgst_data.utils import query

con = psycopg2.connect(dbname='product', host=DB_HOST,
                       port='5439', user=DB_USER, password=DB_PASSWORD)


def delete_duplicate(table, columns, keys):
    selects = ", ".join(map(lambda c: f"{table}.{c}", columns))
    duplicated = " AND ".join(
        map(lambda k: f"{table}.{k} = duplicate.{k}", keys))
    keys_list = ', '.join(keys)

    try:
        query(con, "SET search_path TO mgst;")

        print("Found", query(con, f"""
WITH dup AS (SELECT {keys_list}
FROM {table}
GROUP BY {keys_list}
HAVING
  COUNT(*) > 1
)
SELECT count(*) FROM DUP;
        """, fetch=True)[0][0], "duplicates BEFORE")

        query(con, f"""
CREATE TEMP TABLE duplicate AS
SELECT {keys_list}
FROM {table}
GROUP BY {keys_list}
HAVING
  COUNT(*) > 1;
 
CREATE TEMP TABLE deduped (LIKE {table});

INSERT INTO
  deduped
SELECT
  {selects}
FROM
  duplicate
JOIN (
    SELECT *,
        row_number() over (partition by {keys_list}) as rank
    FROM
        {table}
) {table} ON ({duplicated} AND rank = 1);

DELETE FROM
  {table}
USING duplicate
WHERE {duplicated};

INSERT INTO
  {table}
SELECT
  *
FROM
  deduped;

DROP TABLE duplicate;
DROP TABLE deduped;
        """)

        print("Found", query(con, f"""
WITH dup AS (SELECT {keys_list}
FROM {table}
GROUP BY {keys_list}
HAVING
  COUNT(*) > 1
)
SELECT count(*) FROM DUP;
        """, fetch=True)[0][0], "duplicates AFTER")

        con.commit()

        print("Success")
    except:
        con.rollback()
        raise


print("Processing marionette_metadata_language")
delete_duplicate('marionette_metadata_language',
                 ['channel_id', 'platform', 'language', 'type'],
                 ['channel_id', 'platform', 'type'])

print("Processing marionette_metadata_country")
delete_duplicate('marionette_metadata_country',
                 ['channel_id', 'platform', 'country', 'type'],
                 ['channel_id', 'platform', 'type'])

print("Processing marionette_metadata_prod")
delete_duplicate('marionette_metadata_prod',
                 ['channel_id', 'platform', 'language', 'country'],
                 ['channel_id', 'platform'])
