from datetime import datetime, timedelta
import json
import collections
import pytz


def get_dates(dates, begin_offset, end_offset):
    def f(date):
        d = datetime.strptime(date, '%m/%d/%Y')
        d = pytz.timezone('US/Pacific').localize(d).astimezone(pytz.utc)
        start_date = d + timedelta(hours=begin_offset)
        end_date = d + timedelta(hours=end_offset)
        return [
            start_date.isoformat().replace('+00:00', 'Z'),
            end_date.isoformat().replace('+00:00', 'Z')
        ]

    return list(map(f, dates))


events = collections.defaultdict(list)

all_dates = [
    '11/22/2019',
    '11/23/2019',
    '11/24/2019',
]

events['pubgmobile'].extend(
    list(map(lambda x: {
        "eventName": "PMCO Global Prelims",
        "startDate": x[0],
        "endDate": x[1],
        "channels": {
            "ru": {
                "name": "pubgmobilerussia",
                "displayName": "pubgmobilerussia"
            },
            "pt": {
                "name": "pubgmobilePT",
                "displayName": "pubgmobilePT"
            },
            "ms": {
                "name": "pubgmobileMS",
                "displayName": "pubgmobileMS"
            },
            "vi": {
                "name": "pubgmobileVI",
                "displayName": "pubgmobileVI"
            },
            "es": {
                "name": "pubgmobileES",
                "displayName": "pubgmobileES"
            },
            "tr": {
                "name": "pubgmobileturkish",
                "displayName": "pubgmobileturkish"
            },
            "de": {
                "name": "pubgmobilegermany",
                "displayName": "pubgmobilegermany"
            },
            "fr": {
                "name": "pubgmobilefrancais",
                "displayName": "pubgmobilefrancais"
            },
            "id": {
                "name": "pubgmobileID",
                "displayName": "pubgmobileID"
            },
            "ar": {
                "name": "pubgmobileARA",
                "displayName": "pubgmobileARA"
            },
            "hi": {
                "name": "pubgmobileHI",
                "displayName": "pubgmobileHI"
            },
            "th": {
                "name": "pubgmobileTH",
                "displayName": "pubgmobileTH"
            },

        }}, get_dates(all_dates, 23.5, 24 + 6.5)))
)


print(json.dumps(events, indent=2))
