import time

from absl import app, flags, logging
from absl.flags import FLAGS
import psycopg2
import pandas as pd

from mgst_data.config import DB_HOST, DB_USER, DB_PASSWORD
from mgst_data.utils import upsert_data, date_validator, query

flags.DEFINE_string('csv', None, 'csv file path')
flags.mark_flag_as_required('csv')

# https://docs.google.com/spreadsheets/d/1vKFNPaP0devhxa8jD_kIsVYNY53GICyf6qhNaFZI7z8

def main(_argv):
    con = psycopg2.connect(dbname='product', host=DB_HOST,
                           port='5439', user=DB_USER, password=DB_PASSWORD)

    df = pd.read_csv(FLAGS.csv)
    df['type'] = 'trusted'

    logging.info("Loaded Data:\n%s", df)

    l_data = df[['channel_id', 'platform', 'language', 'type']].values.tolist()
    upsert_data(con,
                'mgst.marionette_metadata_language',
                ['channel_id', 'platform', 'language', 'type'],
                ['channel_id', 'platform', 'type'],
                l_data)

    c_data = df[['channel_id', 'platform', 'country', 'type']].values.tolist()
    upsert_data(con,
                'mgst.marionette_metadata_country',
                ['channel_id', 'platform', 'country', 'type'],
                ['channel_id', 'platform', 'type'],
                c_data)

    print('Done')


if __name__ == '__main__':
    app.run(main)
