date_filter = "date >= CURRENT_DATE - interval '3 days'"
platforms = ['mobile_web']
countries = ['MX', 'BR']
funnel = ['channel_profile', 
"channel_following_placeholder",
"clip",
"channel_videos_placeholder",
"channel_clips_placeholder",
"channel_events_placeholder",
"event_details",
"directory_game",
"search",
"channel_followers_placeholder",
"vod",
"channel",
"not_found",
"channel_collections_placeholder",
"directory_main_game",
"internal_error",
"mobile_upsell",
"clips_embed",
"directory_game_all",
]

events=[
#     {
#     "name": 'channel_profile',
#     "tables": ['pageview'],
#     "filters": "location = 'channel_profile'",
#     "time": "client_time - interval '5 minute'",
#     "pkeys": ["app_session_id"]
# }, 
{
    "name": 'channel_profile_split',
    "tables": ['pageview'],
    "filters": "location = 'channel_profile'",
    "all_actions": True,
    "split": "referrer_host",
    "pkeys": ["app_session_id"]
},
{
    "name": 'pageview_split',
    "tables": ['pageview'],
    "split": "location",
    "pkeys": ["app_session_id"]
}]

def compose_pkey(table_name, event):
    res = ""
    keys = ['%s.%s' % (table_name, pkey) for pkey in event.get('pkeys', [])]
    return '||'.join(keys)

subqueries = []
for i, e in enumerate(events):
    if len(e['tables']) == 1:
        if 'split' in e:
            actions = "', '".join(funnel)
            action_filter = f"AND {e['tables'][0]}.{e['split']} in ('{actions}')" if not e.get('all_actions') else ""
            subqueries.append((f"t_{e['name']}_{e['split']}", f"""
                t_{e['name']}_{e['split']} as (
                    SELECT {compose_pkey(e['tables'][0],  e)} AS pkey,
                        {e['tables'][0]}.platform,
                        {e['tables'][0]}.country,
                        CASE WHEN {e['tables'][0]}.{e['split']} IS NULL THEN 'NULL_{e['tables'][0]}.{e['split']}' ELSE {e['tables'][0]}.{e['split']} END AS action,
                        {e.get('time', f"{e['tables'][0]}.client_time")} AS time
                    FROM spade.{e['tables'][0]} as {e['tables'][0]}
                    {f"JOIN {subqueries[0][0]} ON {compose_pkey(e['tables'][0], e)} = {subqueries[0][0]}.pkey" if i != 0 else ''}
                    WHERE {date_filter}
                    AND {e['tables'][0]}.platform in ({", ".join(["'%s'" % p for p in platforms])})
                    AND {e['tables'][0]}.country in ({", ".join(["'%s'" % c for c in countries])})
                    {f"AND {e['filters']}" if 'filters' in e else ''}
                    {action_filter}
                )"""))
        else:
            subqueries.append((f"t_{e['name']}", f"""
                t_{e['name']} as (
                    SELECT {compose_pkey(e['tables'][0], e)} AS pkey,
                        {e['tables'][0]}.platform,
                        {e['tables'][0]}.country,
                        '{e['name']}' :: TEXT AS action,
                        {e.get('time', f"{e['tables'][0]}.client_time")} AS time
                    FROM spade.{e['tables'][0]} AS {e['tables'][0]}
                    {f"JOIN {subqueries[0][0]} ON {compose_pkey(e['tables'][0], e)} = {subqueries[0][0]}.pkey" if i != 0 else ''}
                    WHERE {date_filter}
                    AND {e['tables'][0]}.platform in ({", ".join(["'%s'" % p for p in platforms])})
                    AND {e['tables'][0]}.country in ({", ".join(["'%s'" % c for c in countries])})
                    {f"AND {e['filters']}" if 'filters' in e else ''}
                    AND '{e['name']}' in ('{"', '".join(funnel)}')
            )"""))
    elif len(e['tables']) == 2:
        subqueries.append((f"t_{e['name']}", f"""
            t_{e['name']} as (
                SELECT {compose_pkey(e['tables'][0], e)} AS pkey,
                    {e['tables'][0]}.platform,
                    {e['tables'][0]}.country,
                    '{e['name']}' :: TEXT AS action,
                    {e.get('time', f"{e['tables'][0]}.client_time")} AS time
                FROM spade.{e['tables'][0]} AS {e['tables'][0]}
                {f"JOIN t_{events[0]['name']} ON {compose_pkey(e['tables'][0], e)} = t_{events[0]['name']}.pkey" if i != 0 else ''}
                WHERE {date_filter}
                AND {e['tables'][0]}.{platform_filter}
                AND {e['tables'][0]}.{country_filter}
                AND '{e['name']}' in ('{"', '".join(funnel)}')
                UNION
                SELECT {e['tables'][1]}.device_id,
                    {e['tables'][1]}.platform,
                    {e['tables'][1]}.country,
                    '{e['name']}' :: TEXT AS action,
                    {e.get('time', f"{e['tables'][0]}.client_time")} AS time
                FROM spade.{e['tables'][1]} AS {e['tables'][1]}
                {f"JOIN t_{events[0]['name']} ON {compose_pkey(e['tables'][1], e)} = t_{events[0]['name']}.pkey" if i != 0 else ''}
                WHERE {date_filter}
                AND {e['tables'][1]}.{platform_filter}
                AND {e['tables'][1]}.{country_filter}
                AND '{e['name']}' in ('{"', '".join(funnel)}')
        )"""))

query = f"""
WITH {", ".join(map(lambda x: x[1], subqueries))},
combined AS ({" UNION ".join(map(lambda x: f"SELECT pkey, country, platform, action, time FROM {x[0]}", subqueries))}),
     connection1 AS
  (SELECT pkey,
          "time",
          LAG(action) OVER (PARTITION BY pkey
                            ORDER BY time) AS prev_action,
          LEAD(action) OVER (PARTITION BY pkey
                             ORDER BY time) AS next_action,
          action
   FROM combined),
     connection2 AS
  (SELECT connection1.pkey,
          connection1. "time",
          prev_action,
          action,
          next_action
   FROM connection1
     WHERE (next_action != action
          OR next_action IS NULL)),
  connection AS
    (SELECT prev_action,
            action,
            next_action,
            ROW_NUMBER() OVER (PARTITION BY connection2.pkey
                               ORDER BY connection2.time) AS action_idx
     FROM connection2)
    SELECT prev_action,
           next_action,
           action,
           action_idx,
           COUNT(*) AS count
  FROM
  connection
GROUP BY prev_action,
         next_action,
         action,
         action_idx
ORDER BY action_idx ASC,
         count DESC
"""
print(query)
