# MGST Infra

## Run jupyter notebook
```bash
scripts/jupyter.sh
```

## Install Tools
```bash
brew install awscli
brew install aws-iam-authenticator
brew install terraform
brew install kubernetes-cli
```

## Deployment 

```bash
# Login to account
source scripts/aws_login.sh
aws-login twitch-esports-exp-tahoe

# Create jenkins user
./scripts/jenkins_user.sh twitch-esports-exp-tahoe

# Create deployer
aws iam create-role --role-name deploy --description "Deploy to AWS Account" --assume-role-policy-document=file://./scripts/jenkins_deploy_policy.json
aws iam attach-role-policy --role-name deploy --policy-arn arn:aws:iam::aws:policy/AdministratorAccess

# Login with jenkins user
aws-logout
export AWS_SHARED_CREDENTIALS_FILE=twitch-esports-exp-tahoe
export AWS_PROFILE=twitch-esports-exp-tahoe
export AWS_STS_REGIONAL_ENDPOINTS=regional
aws sts get-caller-identity --region us-west-2

# Assume deployer
aws sts assume-role --role-arn=arn:aws:iam::$(echo $(aws sts get-caller-identity --query Account --output text)):role/deploy  --role-session-name=assume-deploy --region us-west-2
