function aws-login() {
  role=${2:-Admin}

  # Get account id and role, generate json payload
  JSONBITS=$(curl -Ls -b ~/.midway/cookie -c ~/.midway/cookie -H "x-amz-target: com.amazon.isengard.coral.IsengardService.GetPermissionsForUser" --header "Content-Encoding: amz-1.0" -X POST https://isengard-service.amazon.com/ | jq -r '.PermissionsForUserList[] | select(.AWSAccountMoniker.Status == "ACTIVE") | select(.AWSAccountMoniker.Name == "'$1'") | {AWSAccountID: .AWSAccountID, IAMRoleName: "'$role'" }')
  if [[ $? != 0 ]]; then
    echo "Error: did you forget to mwinit"
    mwinit
    JSONBITS=$(curl -Ls -b ~/.midway/cookie -c ~/.midway/cookie -H "x-amz-target: com.amazon.isengard.coral.IsengardService.GetPermissionsForUser" --header "Content-Encoding: amz-1.0" -X POST https://isengard-service.amazon.com/ | jq -r '.PermissionsForUserList[] | select(.AWSAccountMoniker.Status == "ACTIVE") | select(.AWSAccountMoniker.Name == "'$1'") | {AWSAccountID: .AWSAccountID, IAMRoleName: "'$role'" }')
    if [[ $? != 0 ]]; then
      echo "Error: failed to fetch cookie"
      return 1
    fi
  fi
  # Using said JSON payload, get the variables to assume the roles, and then display them in shell variable form
  # You can also $(eval getMidwayCreds)
  # This is ugly because nested JSON.
  CREDS=$(curl -Ls -b ~/.midway/cookie -c ~/.midway/cookie -H "x-amz-target: com.amazon.isengard.coral.IsengardService.GetAssumeRoleCredentials" --data-binary "${JSONBITS}" --header "Content-Encoding: amz-1.0" --header "Content-type: application/json" -X POST https://isengard-service.amazon.com/ | jq -r . | jq -r .AssumeRoleResult | jq -r '"['$1']\nAWS_ACCESS_KEY_ID=\(.credentials.accessKeyId)\nAWS_SECRET_ACCESS_KEY=\(.credentials.secretAccessKey)\nAWS_SESSION_TOKEN=\(.credentials.sessionToken)"')

  if [[ $? != 0 ]]; then
    echo "Error: cannot get credentials for $1"
    return 1
  fi

  echo $CREDS
  eval $(echo $CREDS | sed 1,1d | sed 's/^/export /g')
}

function aws-logout() {
  unset AWS_PROFILE
  unset AWS_ACCESS_KEY_ID
  unset AWS_SECRET_ACCESS_KEY
  unset AWS_SESSION_TOKEN
  unset AWS_SHARED_CREDENTIALS_FILE
}

function aws-assume() {
  temp_role=$(aws sts assume-role \
                    --role-arn "$1" \
                    --role-session-name assume-role-session)
  if [[ $? != 0 ]]; then
    echo "Assume failed, please try again"
  else
    export AWS_ACCESS_KEY_ID=$(echo $temp_role | jq .Credentials.AccessKeyId | xargs)
    export AWS_SECRET_ACCESS_KEY=$(echo $temp_role | jq .Credentials.SecretAccessKey | xargs)
    export AWS_SESSION_TOKEN=$(echo $temp_role | jq .Credentials.SessionToken | xargs)
  fi
}