#!/usr/bin/env zsh

set -e

NAME=${1:-"twitch-esports-exp-tahoe"}

source ./scripts/aws_login.sh

aws-logout
aws-login $NAME

if [[ -z $(cat ~/.aws/config | grep "\[profile $NAME\]") ]]; then
    echo "creating aws profile for $1"
    mkdir -p ~/.aws    
    echo "[profile $NAME]\nregion = us-west-2\n" >> ~/.aws/config
fi

DIR=$(pwd)
REPO=$(mktemp -d)
git clone git@git-aws.internal.justin.tv:twitch/jenkins_cf_user.git $REPO
cd $REPO 
AWS_PROFILE=$NAME ./create_jenkins_user.sh
mv $NAME $DIR/$NAME
rm -rf $REPO