provider "aws" {
  region = var.region
}

module "glue-redshift" {
  source = "git::git+ssh://git@git.xarth.tv/esports-exp/db-s3-glue.git?ref=4cb24208d5a3ac33826f6a5ed82f80c35cfdee94"
  database_type = "redshift"
  job_name = "mgst-redshift-export"
  cluster_name = "${data.aws_redshift_cluster.redshift.id}"
  trigger_schedule = "0 12 * * ? *" # 5am PST
  table_config = {
    "marionette_metadata_prod" = <<EOF
  {
    "tahoe_view_name": "marionette_metadata",
    "dpu_count": 2,
    "namespace": "mgst",
    "hashfield": "channel_id",
    "version": 1,
    "schema": [
      { "name": "platform", "type": "string" },
      { "name": "channel_id", "type": "string", "sensitivity": "otherid" },
      { "name": "channel_name", "type": "string", "sensitivity": "otherid" },
      { "name": "language", "type": "string" },
      { "name": "language_type", "type": "string" },
      { "name": "country", "type": "string" },
      { "name": "country_code", "type": "string" },
      { "name": "country_type", "type": "string" },
      { "name": "link", "type": "string" }
    ]
  }
  EOF
    "mobile_games" = <<EOF
  {
    "tahoe_view_name": "marionette_mobile_games",
    "dpu_count": 2,
    "namespace": "mgst",
    "version": 0,
    "schema": [
      {"name": "name", "type": "string" }
    ]
  }
  EOF
  }
  s3_output_bucket = "mgst-redshift-export"
  s3_output_key = "mgst-redshift-export"
  s3_script_bucket = "aws-glue-scripts-${data.aws_caller_identity.current.account_id}-${var.region}"
  create_s3_script_bucket = 1
  error_sns_topic_name = "mgst-sns-topic"
  account_number = "${data.aws_caller_identity.current.account_id}"
  vpc_id = "${data.aws_redshift_cluster.redshift.vpc_id}"
  subnet_id = "${data.aws_subnet.tahoe-subnet-private[0].id}"
  availability_zone = "${data.aws_redshift_cluster.redshift.availability_zone}"
  skip_snapshot = "True"
  rds_subnet_group = ""
  cluster_username = "mgst_admin"
  db_password_parameter_name = "/mgst-tahoe/tahoe_password"
  db_password_key_id = ""
  api_key_parameter_name = "/mgst-tahoe/tahoe_api_key"
  api_key_kms_key_id = "alias/aws/ssm"
  tahoe_producer_name = "mgstredshiftexport"
  tahoe_producer_role_arn = "arn:aws:iam::331582574546:role/producer-mgstredshiftexport"
}

output "s3_kms_key" {
  value = "${module.glue-redshift.s3_kms_key}"
}

output "s3_output_bucket" {
  value = "${module.glue-redshift.s3_output_bucket}"
}

output "glue_role" {
  value = "${module.glue-redshift.glue_role}"
}