data "aws_caller_identity" "current" {}
data "aws_availability_zones" "all" {}

# Defined in https://git-aws.internal.justin.tv/terraform-modules/account_template
# Deployed By https://git-aws.internal.justin.tv/stats/tahoe-read-replicas/tree/master/esports-experience/vpc 
data "aws_vpc" "tahoe-vpc" {
  tags = {
    Name = "esports-experience"
    Src  = "account_template_tf_module"
  }
}

data "aws_subnet" "tahoe-subnet-private" {
  vpc_id = "${data.aws_vpc.tahoe-vpc.id}"
  count  = 3

  tags = {
    Name               = "Private - ${element(data.aws_availability_zones.all.names, count.index)}"
    immutable_metadata = "{\"purpose\":\"private\"}"
    Src                = "account_template_tf_module"
  }
}

data "aws_redshift_cluster" "redshift" {
  cluster_identifier = "esports-experience-tahoe-replica"
}

# Remote States From https://git-aws.internal.justin.tv/stats/tahoe-read-replicas/tree/master/esports-experience
data "terraform_remote_state" "tahoe-admin" {
  backend = "s3"
  config = {
    bucket   = "science-tahoe-read-replica-terraform"
    key      = "state/esports-experience/admin"
    region   = "us-west-2"
    role_arn = "arn:aws:iam::673385534282:role/tahoe-read-replica-terraform-management"
  }
}

data "terraform_remote_state" "tahoe-redshift" {
  backend = "s3"
  config = {
    bucket   = "science-tahoe-read-replica-terraform"
    key      = "state/esports-experience/cluster"
    region   = "us-west-2"
    role_arn = "arn:aws:iam::673385534282:role/tahoe-read-replica-terraform-management"
  }
}
