variable "name" {
  description = "resource name"
  type        = string
}

variable "serviceaccount" {
  description = "namespace:name"
  type        = string
}

variable "policy_arns" {
  description = "policy arns"
  type        = list(string)
}

variable "oidc_arn" {
  type = string
}

variable "oidc_url" {
  type = string
}

resource "aws_iam_role" "role" {
  name = var.name

  assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Principal": {
        "Federated": "${var.oidc_arn}"
      },
      "Action": "sts:AssumeRoleWithWebIdentity",
      "Condition": {
        "StringEquals": {
          "${var.oidc_url}:sub": "system:serviceaccount:${var.serviceaccount}"
        }
      }
    }
  ]
}
EOF
}

resource "aws_iam_role_policy_attachment" "policy_attachment" {
  count      = length(var.policy_arns)
  role       = aws_iam_role.role.name
  policy_arn = var.policy_arns[count.index]
}

output "role-arn" {
  value = aws_iam_role.role.arn
}
