
# VPC Endpoint for LDAP group
data "aws_vpc_endpoint" "ldap-vpce" {
  vpc_id       = data.aws_vpc.tahoe-vpc.id
  service_name = "com.amazonaws.vpce.us-west-2.vpce-svc-0437151f68c61b808"
}

# CNAME for SSL Cert
resource "aws_route53_record" "ldap" {
  zone_id = aws_route53_zone.justin-tv.zone_id
  name    = "ldap-${var.name}.internal.justin.tv"
  type    = "CNAME"
  ttl     = "300"
  records = [data.aws_vpc_endpoint.ldap-vpce.dns_entry[0].dns_name]
}

# Have to attach this manually :cry:
resource "aws_security_group" "ldap" {
  name   = "${var.name}-ldap"
  vpc_id = data.aws_vpc.tahoe-vpc.id

  ingress {
    from_port = 636
    to_port   = 636
    protocol  = "tcp"

    security_groups = [
      data.aws_security_group.teleport-jumpbox.id,
      module.eks-cluster.worker_security_group_id
    ]
  }
}
