output "mgst_ns" {
  value = aws_route53_zone.mgst-xarth-tv.name_servers
}

output "kubeconfig" {
  value     = module.eks-cluster.kubeconfig
  sensitive = true
}

output "ssh_key" {
  value     = tls_private_key.ssh.private_key_pem
  sensitive = true
}

output "ldap_hostname" {
  value = aws_route53_record.ldap.name
}

output "iam_external-dns" {
  value = module.iam-external-dns.role-arn
}

output "iam_mgst-data" {
  value = module.iam-mgst-data.role-arn
}

output "iam_fluent-bit-cloudwatch" {
  value = module.iam-fluent-bit-cloudwatch.role-arn
}

output "iam_jupyter" {
  value = module.iam-jupyter.role-arn
}