resource "aws_security_group_rule" "redshift-wpa2" {
  description = "Allow WPA2 Access"
  type        = "ingress"
  from_port   = 5439
  to_port     = 5439
  protocol    = "tcp"

  # https://git-aws.internal.justin.tv/safety/ipblock/blob/master/internal/handlers/trusted_ips.go
  cidr_blocks = [
    "205.251.233.176/29",
    "205.251.233.48/29",
  ]

  security_group_id = data.terraform_remote_state.tahoe-admin.outputs.redshift_security_group_id
}

resource "aws_security_group_rule" "redshift-fullmerc" {
  description = "Allow Chance Fullmer"
  type        = "ingress"
  from_port   = 5439
  to_port     = 5439
  protocol    = "tcp"

  cidr_blocks = [
    "108.249.132.254/32"
  ]

  security_group_id = data.terraform_remote_state.tahoe-admin.outputs.redshift_security_group_id
}
