data "aws_caller_identity" "current" {}

# Defined in https://git-aws.internal.justin.tv/terraform-modules/account_template
# Deployed By https://git-aws.internal.justin.tv/stats/tahoe-read-replicas/tree/master/esports-experience/vpc 
data "aws_vpc" "tahoe-vpc" {
  tags = {
    Name = "esports-experience"
    Src  = "account_template_tf_module"
  }
}

data "aws_availability_zones" "all" {}

data "aws_subnet" "tahoe-subnet-public" {
  vpc_id = data.aws_vpc.tahoe-vpc.id
  count  = 3

  tags = {
    Name               = "Public - ${element(data.aws_availability_zones.all.names, count.index)}"
    immutable_metadata = "{\"purpose\":\"public\"}"
    Src                = "account_template_tf_module"
  }
}

data "aws_subnet" "tahoe-subnet-private" {
  vpc_id = data.aws_vpc.tahoe-vpc.id
  count  = 3

  tags = {
    Name               = "Private - ${element(data.aws_availability_zones.all.names, count.index)}"
    immutable_metadata = "{\"purpose\":\"private\"}"
    Src                = "account_template_tf_module"
  }
}

data "aws_route_table" "tahoe-public-rt" {
  vpc_id = data.aws_vpc.tahoe-vpc.id

  tags = {
    Name = "external"
    Src  = "account_template_tf_module"
  }
}

data "aws_route_table" "tahoe-private-rt" {
  count = 3

  tags = {
    Name = "internal_${["a", "b", "c"][count.index]}"
    Src  = "account_template_tf_module"
  }
}

data "aws_security_group" "tahoe-twitch_subnets-sg" {
  vpc_id = data.aws_vpc.tahoe-vpc.id

  tags = {
    Name = "twitch_subnets"
    Src  = "account_template_tf_module"
  }
}

# Remote States From https://git-aws.internal.justin.tv/stats/tahoe-read-replicas/tree/master/esports-experience
data "terraform_remote_state" "tahoe-admin" {
  backend = "s3"
  config = {
    bucket   = "science-tahoe-read-replica-terraform"
    key      = "state/esports-experience/admin"
    region   = "us-west-2"
    role_arn = "arn:aws:iam::673385534282:role/tahoe-read-replica-terraform-management"
  }
}

data "terraform_remote_state" "tahoe-redshift" {
  backend = "s3"
  config = {
    bucket   = "science-tahoe-read-replica-terraform"
    key      = "state/esports-experience/cluster"
    region   = "us-west-2"
    role_arn = "arn:aws:iam::673385534282:role/tahoe-read-replica-terraform-management"
  }
}
