resource "aws_cloudformation_stack" "teleport" {
  name         = "${var.name}-teleport"
  template_url = "https://twitch-teleport-remote-production.s3.amazonaws.com/cloudformation/teleport-remote-latest.yaml"
  capabilities = ["CAPABILITY_NAMED_IAM"]
  on_failure   = "DELETE"

  parameters = {
    ClusterName   = "twitch-mgst-tahoe"
    VPC           = data.aws_vpc.tahoe-vpc.id
    Subnets       = data.aws_subnet.tahoe-subnet-private[0].id
    SandstormRole = "teleport-remote-mgst-tahoe"

    EnableJumpbox          = "enabled"
    JumpboxLocalUsers      = ""
    LDAPHostname           = aws_route53_record.ldap.name
    JumpboxAuthorizedGroup = "team-mgst"

    AlertsEmail             = "siyinpen@twitch.tv"
    PagerDutyIntegrationURL = ""
  }
}

# TODO: https://github.com/hashicorp/terraform/issues/11806
data "aws_security_group" "teleport-jumpbox" {
  vpc_id = data.aws_vpc.tahoe-vpc.id

  tags = {
    TeleportClusterName = "twitch-mgst-tahoe"
    TeleportRemoteRole  = "jumpbox"
  }
  depends_on = [aws_cloudformation_stack.teleport]
}
