import traceback
import sys
import threading
import random
import time
import os

# import m3u8

import gi
gi.require_version('Gst', '1.0')
from gi.repository import Gst, GLib
Gst.init(None)

TEST_GPU = False
TEST_COUNT = 1
TEST_SLEEP_DELAY = 0.0
TEST_ENCODE_PNG = False
FORCE_FRAMERATE = 0 # unused
TEST_DECODE_KEYFRAME_ONLY = True #False
TEST_AUTO_EXIT = True
PRINT_FRAME = False
PRINT_LATE_FRAME = False
QUEUE_SIZE = 20
SRC_TARGET_FPS = 60 if not TEST_DECODE_KEYFRAME_ONLY else 0.5
TARGET_FRAME_COUNT_SHUTDOWN = SRC_TARGET_FPS * 60 # 30s, 0 to skip


def link_many(*args):
    if not len(args):
        return
    for index, element in enumerate(args[:-1]):
        next_element = args[index+1]
        if not Gst.Element.link(element, next_element):
            raise TypeError('failed to link {}, {}'.format(element, next_element))


def make_queue(queue_name="", **kwargs):
    props = {k.replace("_", "-"): v for k, v in kwargs.items()}
    if queue_name:
        queue_name += "_"
    name = "%s_queue" % (queue_name)
    queue = Gst.ElementFactory.make("queue", name)
    queue.set_property("max-size-bytes", props.pop("max-size-bytes", 0))
    queue.set_property("max-size-buffers", props.pop("max-size-buffers", 0))
    queue.set_property("max-size-time", props.pop("max-size-time", 0))
    queue.set_property("silent", props.pop("silent", True))
    for k, v in props.items():
        queue.set_property(k, v)
    return queue

def make(element_name, name=None, **kwargs):
    props = {k.replace("_", "-"): v for k, v in kwargs.items()}
    element = Gst.ElementFactory.make(element_name, name)
    if not element:
        raise TypeError('Failed to create element: {}, {} {}'.format(element_name, name, props))
    for k, v in props.items():
        element.set_property(k, v)
    return element

def make_caps(caps_str):
    return make("capsfilter", caps=Gst.Caps.from_string(caps_str))


def get_ts_url(url):
    m3u8_master_playlist = m3u8.load(url).playlists
    ts_urls = []
    for playlist in m3u8_master_playlist:
        print("PLAYLIST STREAM INFO:", playlist.stream_info)
        print("PLAYLIST URL:", playlist.uri)

        playlist = m3u8.load(playlist.uri)
        for seg in playlist.segments:
            print("MEDIA INFO:", "program_date_time:", seg.program_date_time, ", duration:", seg.duration, ", discontinuity:", seg.discontinuity)
            print("MEDIA URL:", seg.uri)
            ts_urls.append(seg.uri)

        print("")
        break
    return ts_urls


counter = 0

def exit(i, f):
    print(i, "bang bang imma outta here.", "\tmistimed_frame:\t", f, "\tmistimed frame percent:\t", f / TARGET_FRAME_COUNT_SHUTDOWN)
    os._exit(0)

class Pipeline:
    def __init__(self, i, url, pipeline=None):
        self.id = str(i).zfill(10)
        self.url = url
        self.pipeline = pipeline
        self.lt = 0
        self.klt = 0
        self.fc = 0
        self.sink_caps = None
        self.timer = None
        self.mistimed_frame = 0

    def fakesink_handoff(self, _, buf, pad):
        self.sink_caps = pad.get_current_caps()
        caps = pad.get_current_caps().to_string()
        now = self.pipeline.get_pipeline_clock().get_time()
        self.fc = self.fc + 1
        if self.fc == 1:
            global counter
            counter = counter + 1
            print(self.id, "Got first frame. Decoded streams counter: ", counter, caps)

        since_ms = (now - self.lt) / 1e6
        target_ms = 1 / SRC_TARGET_FPS * 1000
        target_late_ms = target_ms / 2
        diff_ms = since_ms - target_ms
        is_late = (diff_ms > target_late_ms or diff_ms < target_late_ms * -1)
        if is_late:
            self.mistimed_frame = self.mistimed_frame + 1
        if PRINT_FRAME or (PRINT_LATE_FRAME and is_late):
            s = "early" if diff_ms < 0 else "late"
            print(self.id, "frame count:", str(self.fc), ", since last frame:", round(since_ms, 4), "ms", ",", s, "by:", round(abs(diff_ms), 4))

        if self.fc == TARGET_FRAME_COUNT_SHUTDOWN:
            print(self.id, "got", self.fc, "frames! Shutting down in 2 seconds")
            if self.timer:
                self.timer.cancel()
            self.timer = threading.Timer(2.0, exit, [self.id, self.mistimed_frame])
            self.timer.start()

        self.lt = now

    def parser_buffer_probe_cb(self, pad, info):
        now = self.pipeline.get_pipeline_clock().get_time()


        buf = info.get_buffer()
        if buf.has_flags(Gst.BufferFlags.DELTA_UNIT): # Not keyframe
            return Gst.PadProbeReturn.DROP

        # print (pad.get_current_caps().to_string())
        # print("pipeline id:", self.id, "time:", (now - self.klt) / 1e6, "KEYFRAME FOUND", buf)
        self.klt = now

        return Gst.PadProbeReturn.PASS

    def decoder_probe_cb(self, element, pad_info):
        print (pad_info.type)
        return Gst.PadProbeReturn.PASS

    def make_decoders(self):
        parser = make("h264parse")
        decode_queue_pre = make_queue("decoder-pre", max_size_buffers=QUEUE_SIZE, leaky=0)
        decoder = make("nvdec") if TEST_GPU else make("avdec_h264")
        if TEST_DECODE_KEYFRAME_ONLY:
            decoder.set_property("skip-frame", 32)
        decode_queue_post = make_queue("decoder-post", max_size_buffers=QUEUE_SIZE, leaky=0)
        caps = make_caps("video/x-raw(memory:CUDAMemory)" if TEST_GPU else "video/x-raw")
        downloader = make("cudadownload") if TEST_GPU else make("identity")
        sink = make("fakesink", sync=True, signal_handoffs=True)
        sink.connect("handoff", self.fakesink_handoff)
        elements = [parser, decode_queue_pre, decoder, caps, decode_queue_post, downloader, sink]
        return elements

    def on_tsdemux_cb(self, element, pad):
        caps = pad.get_current_caps().to_string()
        # print("on_ts_demux caps:", caps)

        if not "video" in caps:
            return

        elements = self.make_decoders()

        for s in elements:
            self.pipeline.add(s)

        pad.link(elements[0].get_static_pad('sink'))
        link_many(*elements)

        for e in elements:
            e.set_state(Gst.State.PLAYING)


    def on_hlsdemux_cb(self, element, pad):
        caps = pad.get_current_caps().to_string()
        print("on_hls_demux caps:", caps)

        if not "mpegts" in caps:
            return

        ts_demuxer = make("tsdemux")
        self.pipeline.add(ts_demuxer)
        ts_demuxer.connect("pad-added", self.on_tsdemux_cb)
        pad.link(ts_demuxer.get_static_pad("sink"))
        ts_demuxer.set_state(Gst.State.PLAYING)

    def on_bus_message(self, element, message):
        if message.type == Gst.MessageType.STATE_CHANGED:
            s = message.parse_state_changed()
            print(element.get_name(), message.type, s)

    def start(self):
        should_start_pipeline = self.pipeline is None
        self.pipeline = self.pipeline or Gst.Pipeline.new("mirage_" + str(self.id))

        if should_start_pipeline:
            pass
            # self.pipeline.get_bus().add_signal_watch()
            # self.pipeline.get_bus().connect('message', self.on_bus_message)

        # Fortnite VOD
        uri = self.url or "https://vod-metro.twitch.tv/5aded24a4d6227d3d790_sypherpk_35013724608_1257028058/chunked/index-dvr.m3u8"

        # gst-launch-1.0 souphttpsrc ! hlsdemux ! tsdemux name=mux mux. ! h264parse ! identity drop-buffer-flags=0x00002000 ! avdec_h264 ! videoconvert ! autovideosink

        ext = uri.split('.')[-1]
        src_name = "filesrc" if ext == "mp4" else "souphttpsrc"
        src = make(src_name, location=uri)

        if ext == "mp4":
            demuxer_name = "qtdemux"
        elif ext == "ts":
            demuxer_name = "tsdemux"
        else:
            demuxer_name = "hlsdemux"
        demux = make(demuxer_name)
        elements = [src, demux]
        if demuxer_name == "hlsdemux":
            demux.connect("pad-added", self.on_hlsdemux_cb)
        elif demuxer_name == "tsdemux" or demuxer_name == "qtdemux":
            demux.connect("pad-added", self.on_tsdemux_cb)

        for s in elements:
            self.pipeline.add(s)

        link_many(*elements)

        if should_start_pipeline:
            self.pipeline.set_state(Gst.State.PLAYING)
            print(self.id, "pipeline set to playing")




def main():
    print("Starting", TEST_COUNT, "pipelines. GPU:", TEST_GPU)

    url = "https://usher.ttvnw.net/api/channel/hls/dash24.m3u8?allow_source=true&baking_bread=true&baking_brownies=true&baking_brownies_timeout=1050&fast_bread=true&p=9804146&player_backend=mediaplayer&playlist_include_framerate=true&reassignments_supported=true&sig=9bd357d03f6f571e498f7c633ad29dcd4191ad64&token=%7B%22adblock%22%3Afalse%2C%22authorization%22%3A%7B%22forbidden%22%3Afalse%2C%22reason%22%3A%22%22%7D%2C%22blackout_enabled%22%3Afalse%2C%22channel%22%3A%22dash24%22%2C%22channel_id%22%3A139658194%2C%22chansub%22%3A%7B%22restricted_bitrates%22%3A%5B%5D%2C%22view_until%22%3A1924905600%7D%2C%22ci_gb%22%3Afalse%2C%22geoblock_reason%22%3A%22%22%2C%22device_id%22%3A%22103870b6cfb5d7b8%22%2C%22expires%22%3A1564179496%2C%22game%22%3A%22Apex%20Legends%22%2C%22hide_ads%22%3Afalse%2C%22https_required%22%3Atrue%2C%22mature%22%3Afalse%2C%22partner%22%3Afalse%2C%22platform%22%3A%22web%22%2C%22player_type%22%3A%22site%22%2C%22private%22%3A%7B%22allowed_to_view%22%3Atrue%7D%2C%22privileged%22%3Afalse%2C%22server_ads%22%3Afalse%2C%22show_ads%22%3Atrue%2C%22subscriber%22%3Afalse%2C%22turbo%22%3Afalse%2C%22user_id%22%3A139658194%2C%22user_ip%22%3A%22204.246.162.36%22%2C%22version%22%3A2%7D&supported_codecs=vp09%2Cavc1&cdm=wv"
    url = "/gstreamer/nzt/test.mp4"
    url = "/gstreamer/nzt/shroud_fortnite_720p.mp4"
    # ts_urls = get_ts_url(url)
    # last_ts_url = ts_urls[-1]

    for i in range(TEST_COUNT):
        p = Pipeline(random.randint(0, 2000000000), url)
        p.start()
        time.sleep(TEST_SLEEP_DELAY)

    print("all streams running")


if __name__ == '__main__':
    try:
        main()

        GLib.MainLoop().run()
    except KeyboardInterrupt:
        print("stopping")
    except Exception:
        traceback.print_exc(file=sys.stdout)
        print("sh*t blows")
        sys.exit(1)

