import traceback
import sys
import random
import time

import gi
gi.require_version('Gst', '1.0')

from gi.repository import Gst, GObject, GLib, Gio
GObject.threads_init()
Gst.init(None)
Gio.networking_init()

TEST_GPU = True
TEST_COUNT = 1
TEST_SLEEP_DELAY = 1
TEST_ENCODE_PNG = False
TEST_FRAMERATE = 0

def link_many(*args):
    if not len(args):
        return
    for index, element in enumerate(args[:-1]):
        next_element = args[index+1]
        if not Gst.Element.link(element, next_element):
            raise TypeError('failed to link {}, {}'.format(element, next_element))


def make_queue(queue_name="", **kwargs):
    props = {k.replace("_", "-"): v for k, v in kwargs.items()}
    if queue_name:
        queue_name += "_"
    name = "%s_queue" % (queue_name)
    queue = Gst.ElementFactory.make("queue", name)
    queue.set_property("max-size-bytes", props.pop("max-size-bytes", 0))
    queue.set_property("max-size-buffers", props.pop("max-size-buffers", 0))
    queue.set_property("max-size-time", props.pop("max-size-time", 0))
    queue.set_property("silent", props.pop("silent", True))
    for k, v in props.items():
        queue.set_property(k, v)
    return queue

def make(element_name, name=None, **kwargs):
    props = {k.replace("_", "-"): v for k, v in kwargs.items()}
    element = Gst.ElementFactory.make(element_name, name)
    if not element:
        raise TypeError('Failed to create element: {}, {} {}'.format(element_name, name, props))
    for k, v in props.items():
        element.set_property(k, v)
    return element

def make_caps(caps_str):
    return make("capsfilter", caps=Gst.Caps.from_string(caps_str))



class Pipeline:
    def __init__(self, i):
        self.id = str(i)
        self.pipeline = None
        self.lt = 0

    def fakesink_handoff(self, _, buf, pad):
        now = self.pipeline.get_clock().get_time()
        print("pipeline id:", self.id, "time:", (now - self.lt) / 1e6)
        self.lt = now
        """
        caps = pad.get_current_caps()
        caps_structure = caps.get_structure(0)
        width = caps_structure.get_int("width").value
        height = caps_structure.get_int("height").value
        (_result, mapinfo) = buf.map(Gst.MapFlags.READ)
        buf.unmap(mapinfo)
        timestamp = buf.pts
        """

    def on_decode_pad_added_gpu(self, element, pad):
        caps_string = pad.get_current_caps().to_string()
        if "video" in caps_string:
            print(self.id, "on_decode_pad_added_gpu", caps_string)
            videorate = make("videorate")
            glvideoconvert = make("identity")
            glcapsfilter = make("identity") if TEST_FRAMERATE < 1 else make_caps("video/x-raw(memory:CUDAMemory),framerate={}/1".format(TEST_FRAMERATE))
            gldownload = make("identity")
            fakesink_queue = make("identity") # make_queue("queue", max_size_buffers=2, leaky=2)

            if TEST_ENCODE_PNG:
                sink = make("pngenc")
            else:
                sink = make("fakesink", signal_handoffs=True, sync=True, silent=False)
                sink.connect("handoff", self.fakesink_handoff)

            elements = [videorate, glvideoconvert, glcapsfilter,
                        gldownload, fakesink_queue, sink]

            for e in elements:
                self.pipeline.add(e)

            pad.link(videorate.get_static_pad("sink"))

            link_many(*elements)

            for e in elements:
                e.set_state(Gst.State.PLAYING)
        elif "audio" in caps_string:
            pass

    def on_decode_pad_added(self, element, pad):
        caps_string = pad.get_current_caps().to_string()
        if "video" in caps_string:
            print(self.id, "on_decode_pad_added", caps_string)
            videorate = make("videorate")
            videoconvert = make("videoconvert")
            capsfilter = make_caps("video/x-raw,framerate=1/1,format=BGR")
            fakesink_queue = make_queue("queue", leaky=2)

            if TEST_ENCODE_PNG:
                sink = make("pngenc")
            else:
                sink = make("fakesink", signal_handoffs=True)
                sink.connect("handoff", self.fakesink_handoff)

            elements = [videorate, videoconvert, capsfilter,
                        fakesink_queue, sink]

            for e in elements:
                self.pipeline.add(e)

            pad.link(videorate.get_static_pad("sink"))

            link_many(*elements)

            for e in elements:
                e.set_state(Gst.State.PLAYING)
        elif "audio" in caps_string:
            pass

    def decodebin_ap_sort(self, bin, pad, caps, factories):
        caps_str = caps.to_string()
        # print(caps_str)
        should_sort = False
        for f in factories:
            if f.get_name() == "nvdec":
                should_sort = True

        if should_sort:
            x, y = factories[1], factories[2]
            factories[1] = y
            factories[2] = x

        return factories

    def start(self):
        self.pipeline = Gst.Pipeline.new("mirage_" + str(self.id))

        # Fortnite VOD
        # uri="https://vod-metro.twitch.tv/3a15a6fc728a3e38f359_ninja_34825785696_1245279696/chunked/index-dvr.m3u8"
        uri="https://content.jwplatform.com/manifests/vM7nH0Kl.m3u8"
        uri="https://usher.ttvnw.net/api/channel/hls/myth.m3u8?allow_source=true&baking_bread=true&baking_brownies=true&baking_brownies_timeout=1050&fast_bread=true&p=6231057&player_backend=mediaplayer&playlist_include_framerate=true&reassignments_supported=true&sig=547fbc2f644e599ebaaba818a88e46dc94b96ddf&token=%7B%22adblock%22%3Atrue%2C%22authorization%22%3A%7B%22forbidden%22%3Afalse%2C%22reason%22%3A%22%22%7D%2C%22blackout_enabled%22%3Afalse%2C%22channel%22%3A%22myth%22%2C%22channel_id%22%3A110690086%2C%22chansub%22%3A%7B%22restricted_bitrates%22%3A%5B%5D%2C%22view_until%22%3A1924905600%7D%2C%22ci_gb%22%3Afalse%2C%22geoblock_reason%22%3A%22%22%2C%22device_id%22%3A%22103870b6cfb5d7b8%22%2C%22expires%22%3A1563499148%2C%22game%22%3A%22Fortnite%22%2C%22hide_ads%22%3Afalse%2C%22https_required%22%3Atrue%2C%22mature%22%3Afalse%2C%22partner%22%3Afalse%2C%22platform%22%3A%22web%22%2C%22player_type%22%3A%22site%22%2C%22private%22%3A%7B%22allowed_to_view%22%3Atrue%7D%2C%22privileged%22%3Afalse%2C%22server_ads%22%3Atrue%2C%22show_ads%22%3Atrue%2C%22subscriber%22%3Afalse%2C%22turbo%22%3Afalse%2C%22user_id%22%3A139658194%2C%22user_ip%22%3A%22204.246.162.40%22%2C%22version%22%3A2%7D&supported_codecs=vp09%2Cavc1&cdm=wv"
        uri="http://184.72.239.149/vod/smil:BigBuckBunny.smil/playlist.m3u8"
        uri="https://usher.ttvnw.net/api/channel/hls/lord_kebun.m3u8?allow_source=true&baking_bread=true&baking_brownies=true&baking_brownies_timeout=1050&fast_bread=true&p=9376159&player_backend=mediaplayer&playlist_include_framerate=true&reassignments_supported=true&sig=9f4094a453d8c7bbc2c0319244ab169973376682&token=%7B%22adblock%22%3Atrue%2C%22authorization%22%3A%7B%22forbidden%22%3Afalse%2C%22reason%22%3A%22%22%7D%2C%22blackout_enabled%22%3Afalse%2C%22channel%22%3A%22lord_kebun%22%2C%22channel_id%22%3A163836275%2C%22chansub%22%3A%7B%22restricted_bitrates%22%3A%5B%5D%2C%22view_until%22%3A1924905600%7D%2C%22ci_gb%22%3Afalse%2C%22geoblock_reason%22%3A%22%22%2C%22device_id%22%3A%22103870b6cfb5d7b8%22%2C%22expires%22%3A1563503387%2C%22game%22%3A%22Grand%20Theft%20Auto%20V%22%2C%22hide_ads%22%3Atrue%2C%22https_required%22%3Atrue%2C%22mature%22%3Afalse%2C%22partner%22%3Afalse%2C%22platform%22%3A%22web%22%2C%22player_type%22%3A%22site%22%2C%22private%22%3A%7B%22allowed_to_view%22%3Atrue%7D%2C%22privileged%22%3Afalse%2C%22server_ads%22%3Atrue%2C%22show_ads%22%3Afalse%2C%22subscriber%22%3Atrue%2C%22turbo%22%3Afalse%2C%22user_id%22%3A139658194%2C%22user_ip%22%3A%22204.246.162.40%22%2C%22version%22%3A2%7D&supported_codecs=vp09%2Cavc1&cdm=wv"
        uri="https://usher.ttvnw.net/api/channel/hls/myth.m3u8?allow_source=true&baking_bread=true&baking_brownies=true&baking_brownies_timeout=1050&fast_bread=true&p=4631546&player_backend=mediaplayer&playlist_include_framerate=true&reassignments_supported=true&sig=74b8da54356358cf6a47f90c62d545e352b0e5ac&token=%7B%22adblock%22%3Atrue%2C%22authorization%22%3A%7B%22forbidden%22%3Afalse%2C%22reason%22%3A%22%22%7D%2C%22blackout_enabled%22%3Afalse%2C%22channel%22%3A%22myth%22%2C%22channel_id%22%3A110690086%2C%22chansub%22%3A%7B%22restricted_bitrates%22%3A%5B%5D%2C%22view_until%22%3A1924905600%7D%2C%22ci_gb%22%3Afalse%2C%22geoblock_reason%22%3A%22%22%2C%22device_id%22%3A%22103870b6cfb5d7b8%22%2C%22expires%22%3A1563576442%2C%22game%22%3A%22Fortnite%22%2C%22hide_ads%22%3Afalse%2C%22https_required%22%3Atrue%2C%22mature%22%3Afalse%2C%22partner%22%3Afalse%2C%22platform%22%3A%22web%22%2C%22player_type%22%3A%22site%22%2C%22private%22%3A%7B%22allowed_to_view%22%3Atrue%7D%2C%22privileged%22%3Afalse%2C%22server_ads%22%3Atrue%2C%22show_ads%22%3Atrue%2C%22subscriber%22%3Afalse%2C%22turbo%22%3Afalse%2C%22user_id%22%3A139658194%2C%22user_ip%22%3A%22204.246.162.34%22%2C%22version%22%3A2%7D&supported_codecs=vp09%2Cavc1&cdm=wv"
        uri="https://usher.ttvnw.net/api/channel/hls/mongraal.m3u8?allow_source=true&baking_bread=true&baking_brownies=true&baking_brownies_timeout=1050&fast_bread=true&p=1757028&player_backend=mediaplayer&playlist_include_framerate=true&reassignments_supported=true&sig=b34b999e36b60069fb19e7cdcbb09c201151fdc3&token=%7B%22adblock%22%3Atrue%2C%22authorization%22%3A%7B%22forbidden%22%3Afalse%2C%22reason%22%3A%22%22%7D%2C%22blackout_enabled%22%3Afalse%2C%22channel%22%3A%22mongraal%22%2C%22channel_id%22%3A133705618%2C%22chansub%22%3A%7B%22restricted_bitrates%22%3A%5B%5D%2C%22view_until%22%3A1924905600%7D%2C%22ci_gb%22%3Afalse%2C%22geoblock_reason%22%3A%22%22%2C%22device_id%22%3A%22103870b6cfb5d7b8%22%2C%22expires%22%3A1563577912%2C%22game%22%3A%22Fortnite%22%2C%22hide_ads%22%3Afalse%2C%22https_required%22%3Atrue%2C%22mature%22%3Afalse%2C%22partner%22%3Afalse%2C%22platform%22%3A%22web%22%2C%22player_type%22%3A%22site%22%2C%22private%22%3A%7B%22allowed_to_view%22%3Atrue%7D%2C%22privileged%22%3Afalse%2C%22server_ads%22%3Atrue%2C%22show_ads%22%3Atrue%2C%22subscriber%22%3Afalse%2C%22turbo%22%3Afalse%2C%22user_id%22%3A139658194%2C%22user_ip%22%3A%22204.246.162.34%22%2C%22version%22%3A2%7D&supported_codecs=vp09%2Cavc1&cdm=wv"
        uri="https://usher.ttvnw.net/api/channel/hls/xkraab.m3u8?allow_source=true&baking_bread=true&baking_brownies=true&baking_brownies_timeout=1050&fast_bread=true&p=9475280&player_backend=mediaplayer&playlist_include_framerate=true&reassignments_supported=true&sig=5d34fb0490460be0b5b0bd894c46b3cf65f499c7&token=%7B%22adblock%22%3Atrue%2C%22authorization%22%3A%7B%22forbidden%22%3Afalse%2C%22reason%22%3A%22%22%7D%2C%22blackout_enabled%22%3Afalse%2C%22channel%22%3A%22xkraab%22%2C%22channel_id%22%3A116286055%2C%22chansub%22%3A%7B%22restricted_bitrates%22%3A%5B%5D%2C%22view_until%22%3A1924905600%7D%2C%22ci_gb%22%3Afalse%2C%22geoblock_reason%22%3A%22%22%2C%22device_id%22%3A%22103870b6cfb5d7b8%22%2C%22expires%22%3A1563591521%2C%22game%22%3A%22Overwatch%22%2C%22hide_ads%22%3Afalse%2C%22https_required%22%3Atrue%2C%22mature%22%3Afalse%2C%22partner%22%3Afalse%2C%22platform%22%3A%22web%22%2C%22player_type%22%3A%22site%22%2C%22private%22%3A%7B%22allowed_to_view%22%3Atrue%7D%2C%22privileged%22%3Afalse%2C%22server_ads%22%3Atrue%2C%22show_ads%22%3Atrue%2C%22subscriber%22%3Afalse%2C%22turbo%22%3Afalse%2C%22user_id%22%3A139658194%2C%22user_ip%22%3A%22204.246.162.34%22%2C%22version%22%3A2%7D&supported_codecs=vp09%2Cavc1&cdm=wv"
        f = make("uridecodebin", uri=uri)

        if TEST_GPU:
            f.connect("autoplug-sort", self.decodebin_ap_sort)
            f.connect("pad-added", self.on_decode_pad_added_gpu)
        else:
            f.connect("pad-added", self.on_decode_pad_added)

        src = [f]

        for s in src:
            self.pipeline.add(s)

        self.pipeline.set_state(Gst.State.PLAYING)
        print(self.id, "pipeline set to playing")




def main():
    print("Starting", TEST_COUNT, "pipelines. GPU:", TEST_GPU)

    for i in range(TEST_COUNT):
        p = Pipeline(i)
        p.start()
        time.sleep(TEST_SLEEP_DELAY)

    print("all streams running")


if __name__ == '__main__':
    try:
        main()

        loop = GLib.MainLoop()
        loop.run()
    except KeyboardInterrupt:
        print("stopping")
    except Exception:
        traceback.print_exc(file=sys.stdout)
        print("sh*t blows")
        sys.exit(1)


