import os
import subprocess
import multiprocessing
import time

COUNT = int(os.environ.get('COUNT', '10'))
FILENAME = os.environ.get('FILENAME', "decode_segments.py")
DELAY = int(os.environ.get('DELAY', '0'))

def run():
    os.system("python3 " + FILENAME)

processes = []
print("Running ", COUNT, " processes of ", FILENAME)

for i in range(COUNT):
    p = multiprocessing.Process(target=run, args=())
    p.start()
    processes.append(p)

    if DELAY > 0:
        time.sleep(DELAY / 1000)


[p.join() for p in processes]
print("Done!", COUNT)
