const Promise = require('bluebird');
const AWS = require('aws-sdk');

AWS.config.setPromisesDependency(Promise);

const logger = require('./logger');
const config = require('../config');

class Broadcast {
  constructor() {
  }
  init(config) {
    this.snsArn = config.SNS_ARN;
    this.SNS = new AWS.SNS({ region: config.AWS_REGION });
  }

  async emit(url, id, payload) {
    //no need to keep all 3 of these params -- we merge em immediately anyways
    let entityIdName = `${url.split("/")[1]}_id`;
    let publishMessage = {url};
    publishMessage[entityIdName] = id;
    publishMessage = Object.assign({}, payload, publishMessage);
    // logger.debug("Broadcast.emit", url, id, payload);

    const publishMessageParams = {
      Message: JSON.stringify(publishMessage),
      TopicArn: this.snsArn
    };

    return this.SNS.publish(publishMessageParams).promise();
  }
}

module.exports = new Broadcast();
