const Dispatcher = require('bebo-node-commons').Dispatcher;
const makeESFriendly = Dispatcher.Utils.makeESFriendly;
const Broadcast = require('./broadcast');
const error = require('../classes/error.js');
const logger = require('./logger');
const User = require('./user');
const uuidv4 = require('uuid/v4');

var Analytics = require('../classes/analytics');

var trackQueue = Dispatcher.getInstance({
  pickup_rate_ms: 30 * 1000,
  queueName: 'notification_es'
});


class Notification {

  constructor() {
  }

  init() {
  }

  async track(user_id, type, action, campaign, notification) {

    let user = await User.get(user_id);
    let event = Analytics.mkClientEvent(type, action, null, null, {user});
    event = Object.assign(event, campaign);
    event.notification_nest = makeESFriendly(notification, 1);
    delete event.notification_nest.campaign_nest;
    logger.debug("NOTIFICATION EVENT", JSON.stringify(event, null, 2));
    await trackQueue.writeEvent(event);
  }

  async send(user_id, notification, options) {

    if (Array.isArray(user_id)) {
      for (let u of user_id) {
        await this.send(u, notification, options);
      }
      return;
    }
    let campaign = notification.campaign || {};
    for (let k of Object.keys(options)) {
      if (k.startsWith("campaign")) {
        campaign[k] = options[k];
      }
    }

    let url = "/user/notification";
    if (! notification || !notification.title) {
      throw new error.BadRequest('notification.title is required');
    }
    if (! notification.message) {
      throw new error.BadRequest('notification.message is required');
    }

    if (!notification.icon_url) {
      notification.icon_url = "https://s3-us-west-2.amazonaws.com/bebo-images-usw2/misc/llama_tournament_logo.png";
    }

    notification.url = "/user/notification";
    notification.notification_id = uuidv4();
    notification.campaign = campaign;
    let payload = {
      url,
      user_id,
      result: [notification],
    };
    await Broadcast.emit("/user/notification", user_id, payload); 
    return this.track(user_id, "broadcast", "sent", campaign, notification);
  }
}

module.exports = new Notification();
