const logger = require('../api/logger');

class User {

  constructor() {
  }

  init() {
    let TarlyController = require('../classes/tarly_controller');
    this.model = TarlyController.getModel('user');
    this.accessTokenModel = TarlyController.getModel('access_token');
  }

  async get (user_id) {
    let user = await this.model.findById(user_id, false, false);
    return user && user.toJSON() || null;
  }

  async getMany (user_ids) {
    let users = await this.model.findManyByIds(user_ids, false, false);
    return users.map(u => u.toJSON());
  }

  async getByAccessToken (access_token) {
    let where = {access_token};
    let accessToken = await this.accessTokenModel.findOne(where, false, true);
    if (! accessToken) {
      return null;
    }

    let user = await this.model.findById(accessToken.user_id, false, false);
    return user && user.toJSON() || null;
  }

  async update (user_id, update) {
    let user = await this.model.userModel.updateById(user_id, update);
    return user && user.toJSON() || null;
  }

}
module.exports = new User();
