const logger = require('../api/logger');
const BaseBot = require('./base_bot');
const readline = require('readline').createInterface({
  input: process.stdin,
  output: process.stdout
});

const winnerbot_user = {
  username: process.argv[2],
  password: process.argv[3]
};

function getline(str) {
  return new Promise(resolve => {
    readline.question(str + ' ', answer => {
      resolve(answer);
    });
  });
}

class DuoBot extends BaseBot {
  async login(user) {
    await super.login(user);
  }

  async playRound() {
    await getline('start game? (enter)');
    await this.startGame();
    try {
      while (true) {
        const cmd = await getline('action: (k)ill (d)ie (v)ictory');
        if (cmd === 'k') {
          await this.kill();
        } else if (cmd === 'd') {
          break;
        } else if (cmd === 'v') {
          await this.victory();
          break;
        } else {
          logger.error(`invalid command ${cmd}`);
        }
      }
      await getline('end game? (enter)');
      await this.finishGame();
    } catch (err) {
      logger.error(err);
    }
  }

  async doFSM(entity) {
    let oldState = this.state;
    let old_match_id = this.match && this.match.match_id;
    if (entity.url === '/match') {
      this.match = entity;
      this.set = this.getMySet(entity);
    }
    logger.info(this.user.username, 'doFSM', this.state, entity.url, this.set && this.set.state);
    let match_id = this.match.match_id;

    if (entity.url === '/match' && entity.deleted_dttm) {
      await this.goIdle();
    } else if (entity.url === '/user' && entity.active_match_id) {
      match_id = entity.active_match_id;
      if (old_match_id !== match_id) {
        this.state = 'idle';
        logger.info(this.user.username, 'Enter new match', match_id);
      }
      await this.subscribeMatch(entity.active_match_id);
    } else if (this.state === 'idle') {
      if (entity.url === '/match') {
        if (this.set.state === 'waiting') {
          this.state = 'waiting';
          logger.info(this.user.username, 'Getting ready for match', this.match.match_id);
          await this.simulateLobbyReady();
        } else if (this.set.state === 'started') {
          this.state = 'game';
          this.round = this.set.round;
          if (this.round <= this.match.game_cnt) {
            logger.info(this.user.username, 'Playing round', this.round);
            await this.playRound(entity);
          }
        }
      }
    } else if (this.state === 'waiting') {
      if (entity.url === '/match') {
        if (this.set.state === 'started') {
          this.state = 'game';
          this.round = this.set.round;
          if (this.round <= this.match.game_cnt) {
            logger.info(this.user.username, 'Playing round', this.round);
            await this.playRound(entity);
          }
        }
      }
    } else if (this.state === 'game') {
      if (this.set.state === 'started') {
        if (this.round < this.set.round && this.set.round <= this.match.game_cnt) {
          this.round = this.set.round;
          logger.info(this.user.username, 'Playing round', this.round);
          await this.playRound(entity);
        }
      } else if (this.set.state === 'ended') {
        logger.info(this.user.username, entity.match_id, this.set.set_id, 'set ended');
        this.goIdle();
      }
    } else {
      logger.info(this.user.username, 'unknown handled state messate', entity);
    }

    if (this.state !== oldState) {
      if (this.match.match_id) {
        match_id = this.match.match_id;
      }
      logger.info(this.user.username, match_id, 'state transition', oldState, '->', this.state);
    }
  }
}

(async () => {
  try {
    const bot = new DuoBot();
    await bot.login(winnerbot_user);
    await bot.start();
  } catch (err) {
    logger.error(err);
    logger.error('Unable to start bot');
  }
})();
