const logger = require('../api/logger');
const BaseBot = require('./base_bot');

const winnerbot_user = {
  username: process.argv[2],
  password: process.argv[3]
};

class SoloBot extends BaseBot {
  async login(user) {
    await super.login(user);

    for (const l of this.user.leagues) {
      if (l.team_size === 1 && l.teams[0]) {
        logger.info('found solo league', l.name);
        this.league = l;
        break;
      }
    }
    if (!this.league) {
      throw new Error('bot does not belong in any solo league');
    }
    this.team = this.league.teams[0];
  }

  async createMatch() {
    logger.info("Creating match");
    let msg = {
      method: 'POST',
      url: '/match',
      team_id: this.team.team_id
    };
    // logger.debug("subscribe", msg);
    let match = await this.send(msg);
    // logger.debug("subscribe result", match);
  }

  async doFSM(entity) {
    let oldState = this.state;
    if (entity.url === '/match') {
      this.match = entity;
      this.set = this.getMySet(entity);
    }
    logger.info('doFSM', this.state, entity.url, this.set && this.set.state);
    let match_id = this.match.match_id;

    if (entity.url === '/match' && entity.deleted_dttm) {
      await this.goIdle();
    } else if (entity.url === '/user' && entity.active_match_id) {
      match_id = entity.active_match_id;
      logger.info('Enter new match', match_id);
      await this.subscribeMatch(entity.active_match_id);
    }  else if (entity.url === '/user' && !entity.active_match_id) {
      await this.createMatch();
    } else if (this.state === 'idle') {
      if (entity.url === '/match') {
        if (this.set.state === 'waiting') {
          this.state = 'waiting';
          logger.info('Getting ready for match', this.match.match_id);
          await this.simulateLobbyReady();
        } else if (this.set.state === 'started') {
          this.state = 'game';
          this.round = this.set.round;
          if (this.round <= this.match.game_cnt) {
            logger.info('Playing round', this.round);
            await this.playRound(entity);
          }
        }
      }
    } else if (this.state === 'waiting') {
      if (entity.url === '/match') {
        if (this.set.state === 'started') {
          this.state = 'game';
          this.round = this.set.round;
          if (this.round <= this.match.game_cnt) {
            logger.info('Playing round', this.round);
            await this.playRound(entity);
          }
        }
      }
    } else if (this.state === 'game') {
      if (this.set.state === 'started') {
        if (this.round < this.set.round && this.set.round <= this.match.game_cnt) {
          this.round = this.set.round;
          logger.info('Playing round', this.round);
          await this.playRound(entity);
        }
      } else if (this.set.state === 'ended') {
        logger.info(entity.match_id, this.set.set_id, 'set ended');
        this.goIdle();
      }
    } else {
      logger.info('unknown handled state messate', entity);
    }

    if (this.state !== oldState) {
      if (this.match.match_id) {
        match_id = this.match.match_id;
      }
      logger.info(match_id, 'state transition', oldState, '->', this.state);
    }
  }
}

(async () => {
  try {
    const bot = new SoloBot();
    await bot.login(winnerbot_user);
    await bot.start();
  } catch (err) {
    logger.error(err);
    logger.error('Unable to start bot');
  }
})();
