const config = require('../config');
const logger = require('../api/logger');
const readline = require('readline').createInterface({
  input: process.stdin,
  output: process.stdout
});

const BaseBot = require('./base_bot');

const winnerbot_user = {
  username: process.argv[2],
  password: process.argv[3]
};

function getline(str) {
  return new Promise(resolve => {
    readline.question(str + ' ', answer => {
      resolve(answer);
    });
  });
}

class StepBot extends BaseBot {
  async playRound(msg) {
    await getline('start game? (enter)');
    await this.startGame();
    try {
      while (true) {
        const cmd = await getline('action: (k)ill (d)ie (v)ictory');
        if (cmd === 'k') {
          await this.kill();
        } else if (cmd === 'd') {
          break;
        } else if (cmd === 'v') {
          await this.victory();
          break;
        } else {
          logger.error(`invalid command ${cmd}`);
        }
      }
      await getline('end game? (enter)');
      await this.finishGame();
    } catch (err) {
      logger.error(err);
    }
  }
}

(async () => {
  try {
    const bot = new StepBot();
    await bot.login(winnerbot_user);
    await bot.start();
  } catch (err) {
    logger.error(err);
    logger.error('Unable to start bot');
  }
})();
