const config = require('../config');
const logger = require('../api/logger');
const BaseBot = require('./base_bot');

const sleep = m => new Promise(r => setTimeout(r, m));

const winnerbot_user = {
  username: process.argv[2],
  password: process.argv[3]
};

class WinnerBot extends BaseBot {
  async playRound() {
    await this.startGame();

    try {
      await sleep(3000);
      for (let i = 0; i < Math.floor(Math.random() * 5); i += 1) {
        await this.kill();
        await sleep(3000);
      }
      await sleep(3000);
      if (Math.random() > 0.8) {
        await this.victory();
      }
      await sleep(20000);
      await this.finishGame();
    } catch (err) {
      logger.error(err);
    }
  }
}

(async () => {
  try {
    const bot = new WinnerBot();
    await bot.login(winnerbot_user);
    await bot.start();
  } catch (err) {
    logger.error(err);
    logger.error('Unable to start bot');
  }
})();

