'use strict';
var error = require('../classes/error.js');

module.exports = function(req, res, next) {
  if (!req.is_admin) {
    throw new error.Forbidden('Only an admin can do this action.');
  } else {
    if (!req.acting_user) {
      // fake it
      req.acting_user = {user_id: "service"};
    }
    next();
  }
};
