'use strict';

const config = require('../config.js');
const Helper = require('../classes/helper.js');
const error = require('../classes/error.js');
const User = require('../api/user');

function isValidApiKey(api_key) {
  if (config.API_KEYS.indexOf(api_key) > -1) {
    return true;
  } else {
    return false;
  }
}

var Auth = async function(req, res, next) {
  if ('x-api-key' in req.headers) {
    req.is_admin = isValidApiKey(req.headers['x-api-key']);
  }

  if (req.is_admin && 'x-user-id' in req.headers) {
    let user = await User.get(req.headers['x-user-id']);
    if (!user) {
      return next(new error.Unauthorized());
    }
    if (user.dataValues) {
      user.dataValues.user_id = user.user_id;
    }
    req.acting_user = user;
    return next();
  }
  let access_token =
    req.headers['x-access-token'] ||
    req.query['access_token'] ||
    req.cookies[Helper.cookieName('b_at')];

  if (access_token) {
    let user = await User.getByAccessToken(access_token);
    if (!user) {
      return next(new error.Unauthorized());
    }
    req.acting_user = user;
    next();
  } else {
    next();
  }
};

module.exports = Auth;
