var _ = require('lodash');

const robot_patterns = [
  '360Spider',
  '80legs.com/webcrawler',
  'ADmantX',
  '^123peoplebot',
  '^.{1,4}$',
  '^A1 Website Download',
  '^A12$',
  '^A6-Indexer',
  '^abc',
  '^Aboundex',
  '^About.me',
  '^AdnormCrawler',
  '^AdsBot-Google',
  '^Aghaven',
  '^Anemone',
  '^Apache-HttpClient/',
  '^AppEngine-Google;',
  '^Apple-PubSub',
  '^ArcheType',
  '^AsyncHttpClient',
  '^Atomic_Email_Hunter',
  '^Attribot',
  '^BacklinkCrawler',
  '^Baiduspider',
  '^BDFetch',
  '^BigBozz Bot',
  '^binlar_',
  '^bitlybot',
  '^Browserlet',
  '^Bufferbot',
  '^CatchBot',
  '^CCBot',
  '^check_http',
  '^checks.panopta.com',
  '^CJNetworkQuality',
  '^CloudACL',
  '^coccoc',
  '^COMODO',
  '^Comodo-Certificates-Spider',
  '^Content Crawler',
  '^crawl',
  '^Crowsnest',
  '^curl/',
  '^Docunator',
  '^DomainCrawler',
  '^Domnutch-Bot',
  '^elefent/Elefent',
  '^EventGuruBot',
  '^EventMachine',
  '^Evolution Crawler',
  '^ExactSeek Crawler',
  '^ExB Language Crawler',
  '^facebookexternalhit',
  '^facebookplatform',
  '^Feedfetcher-Google',
  '^feedfinder',
  '^fetch libfetch',
  '^findlinks',
  '^Firefox 5.0.2$',
  '^Firefox$',
  '^FisigBot',
  '^FlightDeckReportsBot',
  '^GarlikCrawler',
  '^geotest',
  '^Gigabot',
  '^gimme60',
  '^Goldfire Server',
  '^Google-Site-Verification',
  '^Google-Test',
  '^Google_Analytics_Content_Experiments',
  '^Google_Analytics_Snippet_Validator',
  '^Googlebot-Image',
  '^gsa-crawler',
  '^Hatena::Bookmark',
  '^HuaweiSymantecSpider',
  '^ia_archiver',
  '^ichiro',
  '^InAGist',
  '^InboundScore',
  '^Influencebot',
  '^ip-web-crawler.com',
  '^it2media-domain-crawler',
  '^IXEbot',
  '^Jakarta',
  '^Java',
  '^KD Bot',
  '^Kimengi/nineconnections.com',
  '^larbin',
  '^libwww-perl',
  '^Linguee Bot',
  '^LinkedInBot',
  '^LongURL API',
  '^LSSRocketCrawler',
  '^Luminator',
  '^Maggie',
  '^magpie-crawler',
  '^Mail.RU',
  '^mantam',
  '^Mediapartners-Google',
  '^MetaURI',
  '^Microsoft Windows Network Diagnostics',
  '^MLBot',
  '^montastic-monitor',
  '^Mozilla/.*(compatible$',
  '^Mozilla/.*Abonti',
  '^Mozilla/.*AcoonBot',
  '^Mozilla/.*AhrefsBot',
  '^Mozilla/.*aiHitBot',
  '^Mozilla/.*AppEngine-Google',
  '^Mozilla/.*archive.org',
  '^Mozilla/.*baidu.com',
  '^Mozilla/.*Baiduspider',
  '^Mozilla/.*BigBozzBot',
  '^Mozilla/.*bingbot',
  '^Mozilla/.*Blekkobot',
  '^Mozilla/.*Butterfly',
  '^Mozilla/.*CareerBot',
  '^Mozilla/.*Cliqusbot',
  '^Mozilla/.*coccoc/',
  '^Mozilla/.*CompSpyBot',
  '^Mozilla/.*Dataprovider Site Explorer',
  '^Mozilla/.*DCPbot',
  '^Mozilla/.*Diffbot',
  '^Mozilla/.*discobot',
  '^Mozilla/.*discoverybot',
  '^Mozilla/.*EasouSpider',
  '^Mozilla/.*Embedly',
  '^Mozilla/.*evc',
  '^Mozilla/.*EventGuruBot',
  '^Mozilla/.*Exositesbot',
  '^Mozilla/.*Ezooms',
  '^Mozilla/.*FacebookStatistics',
  '^Mozilla/.*FlipboardProxy',
  '^Mozilla/.*FriendFeedBot',
  '^Mozilla/.*Genieo',
  '^Mozilla/.*GrapeshotCrawler',
  '^Mozilla/.*Gravitybot',
  '^Mozilla/.*heritrix',
  '^Mozilla/.*HTTrack',
  '^Mozilla/.*ICS)$',
  '^Mozilla/.*IntelCSbot',
  '^Mozilla/.*ips-agent',
  '^Mozilla/.*JikeSpider',
  '^Mozilla/.*KomodiaBot',
  '^Mozilla/.*lemurwebcrawler',
  '^Mozilla/.*ltbot',
  '^Mozilla/.*LucidWorks',
  '^Mozilla/.*Mail.RU',
  '^Mozilla/.*Memorybot',
  '^Mozilla/.*MJ12bot',
  '^Mozilla/.*MojeekBot',
  '^Mozilla/.*monitis - premium monitoring service',
  '^Mozilla/.*MSIE or Firefox mutant; not on Windows server;',
  '^Mozilla/.*NaverJapan',
  '^Mozilla/.*NerdByNature.Bot',
  '^Mozilla/.*news bot',
  '^Mozilla/.*Nigma.ru',
  '^Mozilla/.*Nmap Scripting Engine',
  '^Mozilla/.*oBot',
  '^Mozilla/.*OpenindexSpider',
  '^Mozilla/.*PaperLiBot',
  '^Mozilla/.*Plukkie',
  '^Mozilla/.*ProCogBot',
  '^Mozilla/.*proximic',
  '^Mozilla/.*redditbot',
  '^Mozilla/.*ReverseGet',
  '^Mozilla/.*Robo',
  '^Mozilla/.*ScoutJet',
  '^Mozilla/.*ScribdReader',
  '^Mozilla/.*search.thunderstone.com',
  '^Mozilla/.*Search17Bot',
  '^Mozilla/.*SearchmetricsBot',
  '^Mozilla/.*SemrushBot',
  '^Mozilla/.*SISTRIX Crawler',
  '^Mozilla/.*SiteBot',
  '^Mozilla/.*SiteExplorer',
  '^Mozilla/.*Sosospider',
  '^Mozilla/.*spbot',
  '^Mozilla/.*special_archiver',
  '^Mozilla/.*Statsbot',
  '^Mozilla/.*Steeler',
  '^Mozilla/.*suggybot',
  '^Mozilla/.*SurveyBot',
  '^Mozilla/.*Swarm',
  '^Mozilla/.*SWEBot',
  '^Mozilla/.*TourlentaScanner',
  '^Mozilla/.*TweetedTimes',
  '^Mozilla/.*TweetmemeBot',
  '^Mozilla/.*Undrip Bot',
  '^Mozilla/.*UnisterBot',
  '^Mozilla/.*WASALive-Bot',
  '^Mozilla/.*Wazzup',
  '^Mozilla/.*WBSearchBot',
  '^Mozilla/.*WebmasterCoffee',
  '^Mozilla/.*woriobot',
  '^Mozilla/.*Yahoo',
  '^Mozilla/.*YandexImages',
  '^Mozilla/.*YioopBot',
  '^Mozilla/.*yolinkBot',
  '^Mozilla/.*YoudaoBot',
  '^Mozilla/.*ZEERCHBOT',
  '^msnbot',
  '^mysmutsearch',
  '^news.me',
  '^newsme',
  '^NextGenSearchBot',
  '^NING',
  '^Nuzzel',
  '^OpenWebIndex',
  '^PagesInventory',
  '^panscient.com',
  '^peerindex',
  '^percbotspider',
  '^PercolateCrawler',
  '^perlclient',
  '^Pingdom',
  '^Pinterest',
  '^PostRank',
  '^psbot',
  '^Python-httplib2',
  '^python-requests',
  '^Python-urllib',
  '^rbot',
  '^Readability',
  '^Rielee',
  '^RockmeltEmbed',
  '^Ronzoobot',
  '^Ruby',
  '^SaladSpoon',
  '^SAS Web Crawler',
  '^Scope PreviewBot',
  '^Screaming Frog SEO Spider',
  '^Search-Dev',
  '^SemrushBot',
  '^ShortLinkTranslate',
  '^ShowyouBot',
  '^SiteSucker',
  '^SkimBot',
  '^Slurp',
  '^Sogou',
  '^SolomonoBot',
  '^Sosospider',
  '^spider',
  '^spotinfluence',
  '^squirrobot/',
  '^ssearch_bot',
  '^StatusNet/',
  '^Summify',
  '^Swiftbot',
  '^test',
  '^thumbshots',
  '^TinEye',
  '^TosCrawler',
  '^trovator',
  '^ts_spider',
  '^TurnitinBot',
  '^Twisted',
  '^Twitterbot',
  '^Tweetbot',
  '^UCI IR crawler',
  '^UnwindFetchor',
  '^Updownerbot',
  '^Voyager',
  '^W3C-checklink',
  '^W3C_Validator',
  '^Wada.vn',
  '^Web front page analyser',
  '^Wget',
  '^WinHTTP',
  '^WocBot',
  '^worder',
  '^Wotbox',
  '^wsAnalyzer',
  '^www.integromedb.org',
  '^Xenu Link Sleuth',
  '^Y!J-BRJ/YATS crawler',
  '^yacybot',
  '^Yahoo Pipes',
  '^Yahoo! Slurp China',
  '^Yahoo:LinkExpander',
  '^Yepi/',
  '^Yeti',
  '^yolinkBot',
  'bixo',
  'crawler',
  'Exabot',
  'Google Web Preview',
  'Googlebot',
  'Googlebot-Mobile',
  'ichiro/mobile goo;',
  'InsieveBot',
  'larbin',
  'LinkChecker',
  'MS Search',
  'MSIECrawler',
  'naver.com',
  'Nutch',
  'openwebspider.org',
  'PycURL',
  'Python',
  'ReverseGet',
  'Robot',
  'search.goo.ne.jp',
  'SeznamBot',
  'SISTRIX crawler',
  'SiteIntel.net Bot',
  'Speedy Spider',
  'Spider',
  'StumbleUpon;',
  'TLSProber',
  'trendictionbot',
  'urllib',
  'verticalpigeon.com',
  'VoilaBot',
  'VoilaBotCollector',
  'YamanaLab-Robot',
  'YandexBot',
  'Yeti-Mobile',
  'YodaoBot',
  'Zend_Http_Client'
];

const BOT_REGEX = new RegExp(_.join(robot_patterns, '|'));

var Bot = function(req, res, next) {
  req.isBot = function isBot() {
    var ua = req.headers['user-agent']; // <- node needs lowecase names
    if (ua === 'bebo') {
      return false;
    }
    if (!ua) {
      return true;
    }
    return BOT_REGEX.test(ua);
  };
  return next();
};
module.exports = Bot;
