const logger = require('bebo-node-commons').Logger;

const Single = {
  rounds: (player_count) => {
    return Math.ceil(Math.log(player_count) / Math.log(2));
  },
  size: (count) => {
    let p = (count-1).toString(2).length;
    return Math.pow(2, p);
  }
};


const Double = {

  solver: (round, upper, lower) => {
    round++;

    logger.debug("solver", round, upper, lower);
    if (upper == 1 && lower == 1) {
      return round;
    }

    if (upper < 2 && lower < 1) {
      logger.error("invalid bracket round:", round, "upper:", upper, "lower:", lower);
      throw Error("invalid bracket size");
    }

    let next_upper = Math.floor(upper/2) + upper % 2;
    let next_lower = Math.floor(lower/2) + lower % 2;
    next_lower = next_lower + upper - next_upper;

    if (round === 1) {
      let size = Single.size(upper);
      if (size != upper) {
        next_upper = size/2;
        next_lower = upper - size/2;
      }
    } 

    return Double.solver(round, next_upper, next_lower);
  },
  rounds: (teams) => {
    return Double.solver(0, teams, 0);
  }
};
const Bracket = { Single, Double };
module.exports = Bracket;
