'use strict';
var http = require('http');

// Registers all http errors with their name on this module
// And provides DefaultError for passing defined errors and strings as 500 to next()
//
//  Continue (100)
//  SwitchingProtocols (101)
//  Processing (102)
//  OK (200)
//  Created (201)
//  Accepted (202)
//  Non-AuthoritativeInformation (203)
//  NoContent (204)
//  ResetContent (205)
//  PartialContent (206)
//  Multi-Status (207)
//  AlreadyReported (208)
//  IMUsed (226)
//  MultipleChoices (300)
//  MovedPermanently (301)
//  Found (302)
//  SeeOther (303)
//  NotModified (304)
//  UseProxy (305)
//  TemporaryRedirect (307)
//  PermanentRedirect (308)
//  BadRequest (400)
//  Unauthorized (401)
//  PaymentRequired (402)
//  Forbidden (403)
//  NotFound (404)
//  MethodNotAllowed (405)
//  NotAcceptable (406)
//  ProxyAuthenticationRequired (407)
//  RequestTimeout (408)
//  Conflict (409)
//  Gone (410)
//  LengthRequired (411)
//  PreconditionFailed (412)
//  PayloadTooLarge (413)
//  URITooLong (414)
//  UnsupportedMediaType (415)
//  RangeNotSatisfiable (416)
//  ExpectationFailed (417)
//  I'mateapot (418)
//  MisdirectedRequest (421)
//  UnprocessableEntity (422)
//  Locked (423)
//  FailedDependency (424)
//  UnorderedCollection (425)
//  UpgradeRequired (426)
//  PreconditionRequired (428)
//  TooManyRequests (429)
//  RequestHeaderFieldsTooLarge (431)
//  InternalServerError (500)
//  NotImplemented (501)
//  BadGateway (502)
//  ServiceUnavailable (503)
//  GatewayTimeout (504)
//  HTTPVersionNotSupported (505)
//  VariantAlsoNegotiates (506)
//  InsufficientStorage (507)
//  LoopDetected (508)
//  BandwidthLimitExceeded (509)
//  NotExtended (510)
//  NetworkAuthenticationRequired (511)
//
//  to update list comment out logger below and past above

Object.keys(http.STATUS_CODES).forEach(function(code) {
  var http_message = http.STATUS_CODES[code];
  var name = http_message.replace(/\s+/g, '');
  // logger.info("//  " + name + " (" + code + ")" );
  module.exports[name] = class extends Error {
    constructor(message) {
      if (typeof message === 'string') {
        super(message);
      } else if (typeof message === 'object') {
        super();
        if (message.stack) {
          this.stack = message.stack;
        }
        if (message.message) {
          this.message = message.message;
        } else {
          this.message = http_message;
        }
      } else {
        super(http_message);
      }
      this.code = code;
    }
  };
});

module.exports.DefaultError = class DefaultError extends Error {
  constructor(err) {
    var code = 500;
    if (typeof err === 'string') {
      super(err);
    } else if (typeof err === 'object') {
      super();
      if (err.stack) {
        this.stack = err.stack;
      }
      if (err.code) {
        code = err.code;
      }
      if (err.message) {
        this.message = err.message;
      } else {
        this.message = http.STATUS_CODES[code];
      }
    } else {
      super(http.STATUS_CODES[code]);
    }
    this.code = code;
  }
};
