const TarlyController = require('../classes/tarly_controller');

let adjectives = [
  '1337',
  '666',
  'aggro',
  'alpha',
  'altered',
  'ancient',
  'angel',
  'anonymous',
  'aqua',
  'arcane',
  'ashen',
  'assault',
  'atomic',
  'awakened',
  'bad',
  'baneful',
  'bio',
  'bionic',
  'black',
  'blade',
  'blessed',
  'blood',
  'bloody',
  'boosted',
  'brutal',
  'buffed',
  'carnage',
  'catastrophic',
  'chaos',
  'charged',
  'chrome',
  'chrono',
  'combo',
  'concealed',
  'consumptive',
  'corrupted',
  'creeping',
  'crimson',
  'cryptic',
  'cunning',
  'cyber',
  'dark',
  'darth',
  'dead',
  'decimate',
  'deep',
  'destructive',
  'devil',
  'diamond',
  'divine',
  'doom',
  'dormant',
  'draconic',
  'dynamic',
  'elder',
  'electro',
  'elite',
  'emerald',
  'enemy',
  'eon',
  'epic',
  'eradicate',
  'evanescent',
  'exiled',
  'fallen',
  'fatal',
  'fire',
  'first',
  'frost',
  'frozen',
  'gold',
  'gosu',
  'grim',
  'guerilla',
  'hardcore',
  'hate',
  'hazardous',
  'hidden',
  'holy',
  'icy',
  'imba',
  'incendiary',
  'incognito',
  'infinite',
  'invisible',
  'iron',
  'killer',
  'last',
  'leeroy',
  'lone',
  'mad',
  'majestic',
  'malefic',
  'malevolent',
  'malignant',
  'master',
  'menacing',
  'metal',
  'mind',
  'mirror',
  'mist',
  'mono',
  'moon',
  'murderous',
  'mystic',
  'nameless',
  'necro',
  'negative',
  'neo',
  'nightmare',
  'nocturnal',
  'occult',
  'omnipotent',
  'panic',
  'pernicious',
  'platinum',
  'prime',
  'psychic',
  'quantum',
  'radical',
  'radient',
  'rage',
  'random',
  'savage',
  'secret',
  'shadow',
  'silver',
  'sinister',
  'sky',
  'solar',
  'solid',
  'solitary',
  'somber',
  'soul',
  'stealth',
  'steel',
  'storm',
  'supernatural',
  'swift',
  'terror',
  'toxic',
  'tranquil',
  'transcendent',
  'treacherous',
  'true',
  'twisted',
  'uber',
  'ultimate',
  'undercover',
  'unknowable',
  'unpredictable',
  'urban',
  'veiled',
  'venom',
  'vindictive',
  'virulent',
  'warp',
  'wicked',
  'xeno',
  'zero'
];

const nouns = [
  'aegis',
  'aether',
  'agent',
  'agitator',
  'alias',
  'archetype',
  'archon',
  'armor',
  'arrow',
  'arsenal',
  'arsonist',
  'assassin',
  'assault',
  'asylum',
  'atonement',
  'augur',
  'aura',
  'avenger',
  'axiom',
  'axon',
  'battle',
  'beast',
  'beastmode',
  'being',
  'betrayal',
  'blade',
  'blaster',
  'blaze',
  'blood',
  'boss',
  'burn',
  'cabal',
  'cannon',
  'captain',
  'carnage',
  'caster',
  'cataclysm',
  'catalyst',
  'chaos',
  'chief',
  'child',
  'chimera',
  'clairvoyant',
  'cloud',
  'combat',
  'commander',
  'crypt',
  'cut',
  'cyborg',
  'damage',
  'death',
  'deathmatch',
  'decay',
  'decay',
  'demon',
  'destruction',
  'devil',
  'divinity',
  'doom',
  'doppleganger',
  'dragon',
  'dragoon',
  'dream',
  'dynasty',
  'edge',
  'effect',
  'elder',
  'elixir',
  'elysium',
  'emperor',
  'empire',
  'enemy',
  'enigma',
  'entity',
  'epidemic',
  'equilibrium',
  'equinox',
  'eve',
  'executioner',
  'exekutioner',
  'exodus',
  'explosive',
  'fatality',
  'fate',
  'fire',
  'firebreath',
  'flame',
  'flux',
  'focus',
  'force',
  'freak',
  'frenzy',
  'frost',
  'fury',
  'fusion',
  'galaxy',
  'genesis',
  'ghost',
  'glitch',
  'god',
  'godmode',
  'grenade',
  'grimoire',
  'guard',
  'guardian',
  'gun',
  'hacker',
  'haxxor',
  'headshot',
  'hell',
  'hellion',
  'hivemind',
  'hunter',
  'hysteria',
  'impunity',
  'inferno',
  'intellect',
  'juggernaut',
  'kaos',
  'killer',
  'killswitch',
  'legend',
  'limit',
  'lucifer',
  'machete',
  'machine',
  'maelstrom',
  'master',
  'mercenary',
  'mercy',
  'mind',
  'mine',
  'monarch',
  'monolith',
  'mood',
  'moon',
  'nexus',
  'night',
  'nightmare',
  'ninja',
  'nuke',
  'oath',
  'obelisk',
  'obliteration',
  'oblivion',
  'odyssey',
  'omen',
  'omnichrom',
  'oracle',
  'outlaw',
  'overmind',
  'pain',
  'panic',
  'panzer',
  'paradox',
  'paragon',
  'partisan',
  'planet',
  'plasma',
  'priest',
  'prison',
  'propaganda',
  'prophet',
  'psychosis',
  'punishment',
  'pwner',
  'pyromaniac',
  'quake',
  'rachet',
  'radical',
  'raid',
  'raider',
  'rat',
  'ray',
  'razor',
  'reaper',
  'rebel',
  'redshift',
  'reflux',
  'requiem',
  'rhapsody',
  'ringleader',
  'rival',
  'rogue',
  'root',
  'rush',
  'sabotage',
  'scream',
  'seeker',
  'seer',
  'seizure',
  'shade',
  'shooter',
  'sin',
  'slash',
  'slayer',
  'sniper',
  'snow',
  'soul',
  'space',
  'spark',
  'star',
  'storm',
  'strategy',
  'stroke',
  'tank',
  'tempest',
  'terror',
  'thunder',
  'titan',
  'tornado',
  'trigger',
  'trinity',
  'universe',
  'vehicle',
  'vengeance',
  'venom',
  'venus',
  'visionary',
  'void',
  'voltage',
  'voodoo',
  'vortex',
  'warlock',
  'warrior',
  'whisper',
  'wing',
  'wizard',
  'wolf',
  'zealot',
  'zephyr',
  'zone'
];

const separators = [
  ".",
  "_",
  "-"
];

function randomPick(array) {
  return array[Math.floor(Math.random()*array.length)];
}

async function isUsed(username) {
  const UserModel = TarlyController.getModel('user');
  let user = await UserModel.model.findOne({where: {username}});
  return user != null;
}

async function gamertag() {

  let separator = randomPick(separators);
  let noun = randomPick(nouns);
  let adjective = randomPick(adjectives);
  let name = noun + separator + adjective;
  let used = await isUsed(name);
  if (used) {
    return gamertag();
  }
  return name;
}

// for (let i=0; i < 10; i++) {
//   console.log(gamertag().toLowerCase());
// }
module.exports = gamertag;
