const error = require('../classes/error.js');

const OwnerAuth = (req, resp, next) => {
  if (!req.is_admin && !req.acting_user) {
    throw new error.Unauthorized('No User');
  }
  if (req.acting_user) {
    req.acting_stream = { stream_id: req.acting_user.stream_id };
  }
  next();
};

module.exports = OwnerAuth;
