const TarlyController = require('../classes/tarly_controller');
const logger = require('../api/logger');
const Sequelize = require('sequelize');
const moment = require('moment');
const TarlySQLPool = require('../classes/sql_pool');
const LeagueModel = TarlyController.getModel('league');
const DivisionController = require('./division');

const GET_MATCHES = `
WITH completed_matches AS (
       SELECT match.match_id,
              set.outcome,
              set.scores,
              set.team_id
       FROM match
                   JOIN match_set ON (match_set.match_id = match.match_id)
                   JOIN set ON (set.set_id = match_set.set_id)
       where match.state = 'ended'
         AND match.tournament_id IS NULL
         AND match.created_dttm > :time_since
         AND match.deleted_dttm IS NULL
         AND set.ended_dttm IS NOT NULL
         AND set.deleted_dttm IS NULL
)
SELECT team.team_id,
       completed_matches.match_id,
       completed_matches.scores,
       completed_matches.outcome
FROM team
  LEFT JOIN completed_matches ON (completed_matches.team_id = team.team_id)
WHERE team.league_id = :league_id
  AND team.deleted_dttm IS NULL
;`;

class LeagueController {
  async getQualified(league_id) {
    return TarlySQLPool.query(GET_MATCHES, {
      type: Sequelize.QueryTypes.SELECT,
      replacements: {
        league_id,
        time_since: moment()
          .tz('America/Los_Angeles')
          .startOf('month')
          .toISOString()
      }
    }).then(async matches => {
      const league = await LeagueModel.model.findOne({ where: { league_id } });
      if (!league) {
        logger.error("no league for divsion");
        return [];
      }

      return DivisionController.computeStanding(matches, league.league_id, league.team_size);
    });
  }

}
const singleton = new LeagueController();
module.exports = singleton;
