const logger = require('../api/logger');
const Sequelize = require('sequelize');
const moment = require('moment');
const Op = Sequelize.Op;
const TarlyController = require('../classes/tarly_controller');


class UserGameController {
  constructor() {
    this.userGameModel = TarlyController.getModel('user_game');
  }
 
  async endOpenGames(user_id, now_dttm) {
    if (!now_dttm) {
      now_dttm = new Date();
    } else {
      now_dttm = new Date(now_dttm);
    }
    const opts = {
      plain: false,
      order: [["started_dttm","ASC"]],
      where: {
        user_id,
        ended_dttm: {
          [Op.eq]: null,
        }
      },
      useMaster: true,
    };
    const openGames = await this.userGameModel.findAll2(opts);
    logger.debug("OPEN GAMES", JSON.stringify(openGames, null, 2));
    if (!openGames) {
      return;
    }

    for (const ug of openGames) {
      let maxFortnite = moment(ug.started_dttm).add(30, 'm').toDate();
      let ended_dttm = new Date(Math.min(now_dttm, maxFortnite));
      // is there another games that could be overlapping?
      const opts = {
        plain: false,
        order: [["started_dttm","ASC"]],
        limit: 1,
        where: {
          user_id,
          started_dttm: {
            [Op.between]: [ug.started_dttm, ended_dttm]
          },
          user_game_id: {
            [Op.ne]: ug.user_game_id
          }
        }
      };
      const overlapping = await this.userGameModel.findAll2(opts);
      if (overlapping && overlapping.length > 0) {
        logger.debug("found overlapping games",
          JSON.stringify(ug, null, 2),
          JSON.stringify(overlapping[0], null, 2));
        ended_dttm = overlapping[0].started_dttm;
      }

      ug.ended_dttm = ended_dttm;
      logger.info("ending old game", JSON.stringify(ug, null, 2));
      await ug.save();
      await this.userGameModel.emit(ug.user_game_id);
    }
  }

  async endOldGames() {
    const old = moment().subtract(60, 'm');
    const opts = {
      plain: false,
      order: [["started_dttm","ASC"]],
      where: {
        ended_dttm: {
          [Op.eq]: null,
        },
        started_dttm: {
          [Op.lt]: old,
        }
      },
      useMaster: true,
    };
    const oldGames = await this.userGameModel.findAll2(opts);
    logger.debug("FOUND OLD GAMES", JSON.stringify(oldGames, null, 2));
    if (!oldGames) {
      return;
    }

    for (const ug of oldGames) {
      let maxFortnite = moment(ug.started_dttm).add(30, 'm').toDate();
      let ended_dttm = maxFortnite;
      // is there another games that could be overlapping?
      const opts = {
        plain: false,
        order: [["started_dttm","ASC"]],
        limit: 1,
        where: {
          user_id: ug.user_id,
          started_dttm: {
            [Op.between]: [ug.started_dttm, maxFortnite]
          },
          user_game_id: {
            [Op.ne]: ug.user_game_id
          }
        }
      };
      const overlapping = await this.userGameModel.findAll2(opts);
      if (overlapping && overlapping.length > 0) {
        logger.debug("found overlapping games",
          JSON.stringify(ug, null, 2),
          JSON.stringify(overlapping[0], null, 2));
        ended_dttm = overlapping[0].started_dttm;
      }

      ug.ended_dttm = ended_dttm;
      logger.info("ending old game", JSON.stringify(ug, null, 2));
      await ug.save();
      await this.userGameModel.emit(ug.user_game_id);
    }
  }
}
const singleton = new UserGameController();
module.exports = singleton;
