#!/bin/bash
set -e
set -x

SSH_PRIVATE_KEY=${SSH_PRIVATE_KEY:-~/.ssh/id_rsa}
JOB_NAME=pharah
ENV=${BEBO_ENV:-local}

cp ${SSH_PRIVATE_KEY} ./ssh_private_key

docker build -t ${JOB_NAME}:${ENV} --build-arg "BEBO_ENV=${ENV}" --rm .

rm ./ssh_private_key
docker run -it --rm --network="host" --name ${JOB_NAME} -e "BEBO_ENV=${ENV}" ${JOB_NAME}:${ENV}
