const error = require('../classes/error.js');
const logger = require('../api/logger');
const Bran = require('../models/bran.js');
const admin_wrapper = require('../classes/admin_wrapper.js');

const check_admin = req => {
  return req.is_admin;
};

const BranDetectorHandler = {
  route: '/bran/detector',

  get: {
    wrap: [admin_wrapper],
    callback: (req, res, next) => {
      if (!check_admin(req)) {
        return next(new error.DefaultError('invalid_permission'));
      }

      return Bran.get()
        .then(services => {
          res.result = services;
          next();
        })
        .catch(err => {
          logger.error(err);
          next(new error.DefaultError(err));
        });
    }
  },

  post: {
    wrap: [admin_wrapper],
    callback: (req, res, next) => {
      if (!check_admin(req)) {
        return next(new error.DefaultError('invalid_permission'));
      }

      return Bran.post(req.body)
      .then(() => {
        res.result = req.body;
        next();
      })
      .catch(err => {
        logger.error(err);
        next(new error.DefaultError(err));
      });
    }
  }
};

module.exports = BranDetectorHandler;
