const error = require('../classes/error.js');
const DivisionController = require('../controllers/division');
const asyncMiddleware = require('../classes/async-middleware.js');


module.exports = {
  route: '/division/standing',
  get: asyncMiddleware(async function(req, res, next) {
    const { division_id } = req.query;

    if (!division_id) {
      return next(new error.BadRequest('no division id'));
    }
    res.result = await DivisionController.getDivisionStanding(division_id);
    next();
  })
};
