const error = require('../classes/error.js');
const TarlyController = require('../classes/tarly_controller');
const asyncMiddleware = require('../classes/async-middleware.js');
const _ = require('lodash');

module.exports = {
  route: '/division/team',
  get: asyncMiddleware(async function(req, res, next) {
    if (!req.query.division_id && !req.query.active_division_id) {
      return next(new error.BadRequest("needs division_id"));
    }
    const TeamModel = TarlyController.getModel('team');
    const opts = _.cloneDeep(req.sqlOptions);
    if (!opts.where.active_division_id) {
      opts.where.active_division_id = req.query.division_id;
      delete opts.where.division_id;
    }
    opts.include = _.cloneDeep(TeamModel.config.include);
    opts.useMaster = true;
    res.result = await TeamModel.findAll2(opts);
    return next();
  })
};
