const error = require('../classes/error.js');
const logger = require('../api/logger');
const TarlyController = require('../classes/tarly_controller');
const asyncMiddleware = require('../classes/async-middleware.js');
const _ = require('lodash');

const Sequelize = require('sequelize');

module.exports = {
  route: '/invite',
  post: asyncMiddleware(async function(req, res, next) {
    //check for admin AND acting user => allow logged in users to create invites
    if (!req.is_admin && !req.acting_user) {
      throw new error.Unauthorized('Invalid Permission');
    }

    const { league_id, campaign_name } = req.body;
    //no longer require code, if none is passed the model will generate one automatically.
    if (!league_id || !campaign_name) {
      return next(new error.Forbidden('Missing league_id or campaign_name'));
    }

    const InviteModel = TarlyController.getModel('invite');
    const LeagueModel = TarlyController.getModel('league');
    const league = await LeagueModel.model.findByPk(league_id);
    if (!league) {
      return next(new error.BadRequest('League does not exists'));
    }

    let invite = null;
    try {
      invite = await InviteModel.create(req.body);
    } catch (err) {
      if (err instanceof Sequelize.UniqueConstraintError) {
        return next(new error.Conflict('code is used'));
      }
      return next(new error.DefaultError(err));
    }
    res.result = [invite];
    return next();
  }),

  get: asyncMiddleware(async function(req, res, next) {
    const inviteModel = TarlyController.getModel('invite');
    // only not admin only with code
    let opts = _.cloneDeep(req.sqlOptions);
    opts.include = _.cloneDeep(inviteModel.config.include);
    opts.useMaster = true;

    let invite = await inviteModel.findAll2(opts);
    // if admin get campaign
    logger.debug(invite);
    res.result = invite;
    return next();
  })
};
