const error = require('../classes/error.js');
const logger = require('../api/logger');
const TarlyController = require('../classes/tarly_controller');
const asyncMiddleware = require('../classes/async-middleware.js');

const InviteController = require('../controllers/invite');

module.exports = {
  route: '/invite/accept',
  post: asyncMiddleware(async function(req, res, next) {
    const { acting_user } = req;
    const { code } = req.body;

    const invite = await InviteController.acceptInviteByCode(code, acting_user.user_id);
    res.result = [invite];
    return next();
  }),
};
