
const TarlyController = require('../classes/tarly_controller');
const DivisionController = require('../controllers/division');
const asyncMiddleware = require('../classes/async-middleware');
const AdminWrapper = require('../classes/admin_wrapper');

module.exports = {
  route: '/league',
  post: asyncMiddleware(async function(req, res, next) {
    return AdminWrapper(req, res, async () => {
      const LeagueModel = TarlyController.getModel('league');
      const league = await LeagueModel.createByAuth(req);
      const division = await DivisionController.createDivision(league.league_id);
      league.active_division_id = division.division_id;
      await league.save();

      res.result = [league];
      return next();
    });
  }),
  get: function(req, res, next) {
    return TarlyController.getHandler('league').get(req, res, next);
  },
  put: function(req, res, next) {
    return TarlyController.getHandler('league').put(req, res, next);
  },
  delete: function(req, res, next) {
    return TarlyController.getHandler('league').delete(req, res, next);
  }
};
