const error = require('../classes/error.js');
const LeagueController = require('../controllers/league');
const asyncMiddleware = require('../classes/async-middleware.js');


module.exports = {
  route: '/league/qualified',
  get: asyncMiddleware(async function(req, res, next) {
    const { league_id } = req.query;

    if (!league_id) {
      return next(new error.BadRequest('no league_id'));
    }
    res.result = await LeagueController.getQualified(league_id);
    next();
  })
};
