const error = require('../classes/error.js');
const TarlyController = require('../classes/tarly_controller');
const asyncMiddleware = require('../classes/async-middleware.js');
const _ = require('lodash');

module.exports = {
  route: '/league/team',
  get: asyncMiddleware(async function(req, res, next) {
    if (!req.query.league_id) {
      return next(new error.BadRequest("needs league_id"));
    }
    const TeamModel = TarlyController.getModel('team');
    const opts = _.cloneDeep(req.sqlOptions);
    opts.include = _.cloneDeep(TeamModel.config.include);
    opts.useMaster = true;
    res.result = await TeamModel.findAll2(opts);
    return next();
  })
};
